local MainMenu = Behavior("MainMenu")

function MainMenu:initialize()
  Kernel.musicController:playMainMenuMusic()
  self:addComponent("OptionsMenu")

  Graphics.useFogOfWar(false)
  Camera.setPosition(Vector.zero())

  self:on("destroy", function()
    if self.visible then
      UI.detachView("MainMenu")
      Graphics.useFogOfWar(true)
      Kernel.menuEvents:releaseLock("MainMenu")
    end
  end)

  self.visible = false
  self.selectedIndex = 1

  Kernel.menuEvents:on("menuUp", function()
    if not Kernel.menuEvents:hasLock("MainMenu") then
      return
    end

    if self.selectedIndex > 1 then
      self.selectedIndex = self.selectedIndex - 1
      self:updateBindings()
      Kernel.soundEmitter:postEvent("MenuClick")
    end
  end)

  Kernel.menuEvents:on("menuDown", function()
    if not Kernel.menuEvents:hasLock("MainMenu") then
      return
    end

    if self.selectedIndex < 3 then
      self.selectedIndex = self.selectedIndex + 1
      self:updateBindings()
      Kernel.soundEmitter:postEvent("MenuClick")
    end
  end)

  Kernel.menuEvents:on("menuSelect", function(event)
    if not Kernel.menuEvents:hasLock("MainMenu") then
      return
    end

    self:selectOption()
    event.handled = true
  end)

  Kernel.musicController:playMainMenuMusic()
  self:show()
end

function MainMenu:update(deltaTime)
  self:updateBindings()
end

function MainMenu:updateBindings()
  local bindings = {
    selectedIndex = self.selectedIndex,
    buildNo = _BUILDNO
  }

  UI.updateBinding("MainMenu", bindings)
end

function MainMenu:show()
  if not self.visible and Kernel.menuEvents:takeLock("MainMenu") then
    UI.attachView("MainMenu", "ui/mainmenu.rml")
    self.visible = true
    Kernel.soundEmitter:postEvent("WindowShow")
    self:updateBindings()
  end
end

function MainMenu:hide()
  if not self.visible then
    return
  end

  UI.detachView("MainMenu")
  Kernel.menuEvents:releaseLock("MainMenu")
  Kernel.soundEmitter:postEvent("WindowHide")

  self.visible = false
end

function MainMenu:selectOption()
  if self.selectedIndex == 1 then
    Graphics.useFogOfWar(true)
    self:hide()
    World.setCurrent("worlds/demo/hub.wrld")
  elseif self.selectedIndex == 2 then
    Kernel.menuEvents:releaseLock("MainMenu")
    self.optionsMenu:show()
  elseif self.selectedIndex == 3 then
    if not _EDITOR then
      os.exit()
    else
      Kernel:destroy()
      _L._debugExitSimulation()
    end
  end
end
