local SaveGameManager = require "util/savegamemanager"

local PauseMenu = Behavior("PauseMenu")

function PauseMenu:initialize()
  self:on("destroy", function()
    if self.visible then
      UI.detachView("PauseMenu")
      Kernel.menuEvents:releaseLock("PauseMenu")
      Time.setTimeScale(1.0)
    end
  end)

  self.visible = false
  self.selectedIndex = 1

  Kernel.inputController:on("pause", function(event)
    if self.visible then
      self:hide()
    else
      self:show()
    end

    event.handled = true
  end)

  Kernel.inputController:on("menuBack", function(event)
    if not self.visible then
      return
    end

    self:hide()
    event.handled = true
  end)

  Kernel.inputController:on("menuUp", function(event)
    if not self.visible then
      return
    end

    event.handled = true
    if self.selectedIndex > 1 then
      self.selectedIndex = self.selectedIndex - 1
      self:updateBindings()
      Kernel.soundEmitter:postEvent("MenuClick")
    end
  end)

  Kernel.inputController:on("menuDown", function(event)
    if not self.visible then
      return
    end

    event.handled = true
    if self.selectedIndex < 2 then
      self.selectedIndex = self.selectedIndex + 1
      self:updateBindings()
      Kernel.soundEmitter:postEvent("MenuClick")
    end
  end)

  Kernel.inputController:on("menuSelect", function(event)
    if not self.visible then
      return
    end

    self:selectOption()
    event.handled = true
  end)
end

function PauseMenu:update(deltaTime)
  self:updateBindings()
end

function PauseMenu:updateBindings()
  local bindings = {
    selectedIndex = self.selectedIndex
  }

  UI.updateBinding("PauseMenu", bindings)
end

function PauseMenu:show()
  if not self.visible and Kernel.menuEvents:takeLock("PauseMenu") then
    UI.attachView("PauseMenu", "ui/pausemenu.rml")
    self.visible = true
    Kernel.soundEmitter:postEvent("WindowShow")
    self:updateBindings()
    Time.setTimeScale(0.0)
  end
end

function PauseMenu:hide()
  if not self.visible then
    return
  end

  UI.detachView("PauseMenu")
  Kernel.menuEvents:releaseLock("PauseMenu")
  Kernel.soundEmitter:postEvent("WindowHide")

  self.visible = false
  self.mapToQuickbar = false
  Time.setTimeScale(1.0)
end

function PauseMenu:selectOption()
  if self.selectedIndex == 1 then
    self:hide()
  elseif self.selectedIndex == 2 then
    SaveGameManager.save()
    World.setCurrent("worlds/demo/mainmenu.wrld")
  end
end