local ScreenFade = Behavior("ScreenFade")

function ScreenFade:initialize()
  self.mainCo = nil
  self.viewAttached = false
end

function ScreenFade:fixedUpdate()
  if self.mainCo then
    if not self.mainCo:update() then
      self.mainCo = nil
    end
  end
end

function ScreenFade:fadeIn(time, callback)
  time = time or 0.25

  if self.viewAttached then
    UI.detachView("FadeOut")
  end

  UI.attachView("FadeOut", "ui/fadeout.rml")
  self.viewAttached = true

  UI.updateBinding("FadeOut", {
    alpha = 1.0
  })

  self.mainCo = Co.create(function()
    Co.sleep(0.25)

    local left = time

    while left > 0.0 do
      UI.updateBinding("FadeOut", {
        alpha = left / time
      })

      left = left - Time.fixedDeltaTime
      Co.yield()
    end

    UI.updateBinding("FadeOut", {
      alpha = 0.0
    })

    if self.viewAttached then
      UI.detachView("FadeOut")
      self.viewAttached = false
    end

    if callback then
      callback()
    end
  end)
end

function ScreenFade:fadeOut(time, callback)
  time = time or 0.25

  if self.viewAttached then
    UI.detachView("FadeOut")
  end

  UI.attachView("FadeOut", "ui/fadeout.rml")
  self.viewAttached = true

  local left = time

  self.mainCo = Co.create(function()
    while left > 0.0 do
      UI.updateBinding("FadeOut", {
        alpha = 1.0 - left / time
      })

      left = left - Time.fixedDeltaTime
      Co.yield()
    end

    UI.updateBinding("FadeOut", {
      alpha = 1.0
    })

    if callback then
      callback()
    end
  end)
end
