local AmbushSpawner = Behavior("AmbushSpawner")

AmbushSpawner.property("enemyType", "Knight")
AmbushSpawner.property("radius", 128.0)
AmbushSpawner.property("triggerRadius", 32.0)
AmbushSpawner.property("enemyCount", 4.0)
AmbushSpawner.property("debug", false)

function AmbushSpawner:initialize(properties)
  self.properties = AmbushSpawner.defaultProperties(properties)
  self.debug = self.properties.debug

  local radiusSq = self.properties.triggerRadius * self.properties.triggerRadius

  self.updateCo = Co.throttle(0.25, function()
    while true do
      local pos = self.transform.worldPosition
      local distance = Vector.distance2(self.transform.worldPosition, self.heroRef.transform.worldPosition)
      if distance < radiusSq then
        self:trigger()
      end

      Co.yield()
    end
  end)
end

function AmbushSpawner:awake()
  self.heroRef = BehaviorUtil.findFirstOfType("Hero")
end

function AmbushSpawner:fixedUpdate()
  if not self.updateCo:update() then
    self.object:destroy()
  end
end

function AmbushSpawner:update(deltaTime)
  if not self.heroRef then
    self.object:destroy()
    return
  end

  local pos = self.transform.worldPosition
  if self.debug then
    Debug.drawCircle(pos, self.properties.triggerRadius, 0xFF00FFFF)
    Debug.drawCircle(pos, self.properties.radius, 0xAAAAAAFF)
  end
end

function AmbushSpawner:trigger()
  local pos = self.transform.worldPosition

  CreateObject("Puff", pos + Vector(0.0, -64.0)):addComponent("Puff", 2.0)

  local t = 0.0
  local delta = math.pi * 2.0 / self.properties.enemyCount

  for i=1,self.properties.enemyCount do
    local dir = Vector(math.cos(t), math.sin(t))
    self:spawnEnemy(pos + dir * self.properties.radius)
    t = t + delta
  end

  self.object:destroy()
end

function AmbushSpawner:spawnEnemy(position)
  CreateObject(self.properties.enemyType, position):addComponent(self.properties.enemyType)
end
