local Runes = require "util/runes"

local Hitbox = Behavior("Hitbox")

function Hitbox:initialize()
  local collider = self:addComponent("PhysicsCollider")
  collider.mask = World.layer("Weapon")

  self.categoriesLayer = World.layer("Hitbox")
  collider.categories = self.categoriesLayer

  self.onHit = nil
  self.onDealDamage = nil

  self.knockbackForce = 2400.0
end

function Hitbox:turnOn()
  self.physicsCollider.categories = self.categoriesLayer
end

function Hitbox:turnOff()
  self.physicsCollider.categories = 0
end

function Hitbox:enableEventHandling()
  local parent = self.transform.parent.object
  local health = parent.health

  if not health then
    return
  end

  local movableCollider = parent.physicsCollider

  self.object:on("collisionStart", function(collisionInfo)
    if not health.isAlive then
      return
    end

    local weapon = collisionInfo.object.weapon
    if not weapon then
      return
    end

    local object = nil
    if weapon.transform.parent then
      object = weapon.transform.parent.object
    else
      object = weapon.object
    end

    local connect = weapon:shouldConnect(parent)

    local hitDir

    hitDir = (object.transform.worldPosition - self.transform.worldPosition):normalized()

    local shouldHit = true
    if parent.statusEffects then
      if parent.statusEffects:hasStatusEffect("Frozen") then
        shouldHit = false
      end
    end

    if shouldHit and connect and self.onHit then
      shouldHit = self.onHit(object, hitDir)
    end

    if shouldHit and connect then
      local spawnBlood = true

      if Runes.isEquipped("Vampirism") and object.hero then
        spawnBlood = false
      end

      if spawnBlood then
        local bloodDirection = hitDir * -1.0
        CreateObject("BloodParticles", collisionInfo.pointSelf):addComponent("BloodParticles", bloodDirection)
      else
        CreateObject("LifedrainFX", Vector.zero(), self.object):addComponent("LifedrainFX", weapon.transform)
      end

      local damage = weapon.damage

      if parent.character and object.character and
        parent.character.faction == object.character.faction then

        damage = math.floor(damage * 0.15)
      end

      if self.onDealDamage then
        self.onDealDamage(damage)
      else
        health:takeDamage(damage)
      end

      if weapon.onApplyEffects then
        weapon.onApplyEffects(parent)
      end

      if parent.statusEffects then
        local dir = (parent.transform.worldPosition - object.transform.worldPosition):normalized()
        parent.statusEffects:applyByName("Knockback", { impulse = dir * self.knockbackForce })
      end
    end
  end)
end
