local MobLists = require "data/moblists"

local RandomMobSpawner = Behavior("RandomMobSpawner")

RandomMobSpawner.property("mobList", "DefaultList")
RandomMobSpawner.property("patrolRoute", "", Metatype.Route)
RandomMobSpawner.editorIcon("editor/dice.png")

function RandomMobSpawner:initialize(properties)
  self.properties = RandomMobSpawner.defaultProperties(properties)

  local list = MobLists[self.properties.mobList]
  if not list then
    print("Failed to find mob list \"" .. self.properties.mobList .. "\"")
    self.object:destroy()
    return
  end

  for i, mob in ipairs(list) do
    local roll = Random.value()
    local chance = mob.chance

    if roll < chance then
      local properties = {}

      for k, v in pairs(mob.properties) do
        properties[k] = v
      end

      if self.properties.patrolRoute ~= "" then
        properties.patrolRoute = self.properties.patrolRoute
      end

      self:spawnMob(mob.name, properties)
      self.object:destroy()
      return   
    end
  end
end

function RandomMobSpawner:spawnMob(name, properties)
  CreateObject(name, self.transform.worldPosition):addComponent(name, properties)
end
