local TimeOfDay = Behavior("TimeOfDay")

TimeOfDay.property("startTime", "day")

function TimeOfDay:initialize(properties)
  self.dayLut = AssetUtil.find("no_atlas/default_lut.png")
  self.nightLut = AssetUtil.find("no_atlas/night_lut.png")
  Graphics.setColorLUT(self.dayLut, false)
  Graphics.setColorLUT(self.nightLut, true)

  self.current = "day"
  self.alpha = 1.0

  if properties.startTime ~= "day" then
    self.alpha = 0.0
  end
end

function TimeOfDay:update(deltaTime)
  if self.next == "night" and self.alpha > 0.0 then
    self.alpha = self.alpha - deltaTime * 0.1
    if self.alpha < 0.0 then
      self.alpha = 0.0
      self.current = "night"
      self.next = nil
    end
  elseif self.next == "day" and self.alpha < 1.0 then
    self.alpha = self.alpha + deltaTime * 0.1
    if self.alpha > 1.0 then
      self.current = "day"
      self.next = nil
      self.alpha = 1.0
    end
  end

  Graphics.setColorLUTAlpha(self.alpha)
end

function TimeOfDay:transitionTo(timeOfDay)
  self.next = timeOfDay
end

function TimeOfDay:customEditor()
  self.alpha = EditorUI.sliderFloat("Night/ day", self.alpha, 0.0, 1.0)

  if EditorUI.button("Transition to day") then
    self:transitionTo("day")
  end

  if EditorUI.button("Transition to night") then
    self:transitionTo("night")
  end
end
