local Trigger = Behavior("Trigger")

function Trigger:initialize()
end

function Trigger:initTrigger(triggerData)
  self.bottomLeft = Vector(triggerData.bottomLeft)
  self.topRight = Vector(triggerData.topRight)
  self.size = self.topRight - self.bottomLeft

  self.type = triggerData.type
  self.objectMask = triggerData.objectMask
  self.properties = triggerData.deserializedProps
  self.flags = triggerData.flags

  local collider = self:addComponent("PhysicsCollider")
  collider.mask = self.objectMask
  collider.categories = World.layer("Meta")
  collider:setType(collider.Types.Static)
  collider:addRectangleShape(Vector(0.0, 0.0), self.size, { isSensor = true })

  self:on("collisionStart", function (collision)
    if collision.object:hasAnyListeners("triggerEnter") then
      collision.object:emit("triggerEnter", self.type, self.properties)
    end
  end)

  self:on("collisionEnd", function (collision)
    if collision.object:hasAnyListeners("triggerExit") then
      collision.object:emit("triggerExit", self.type, self.properties)
    end
  end)
end
