local Weapon = Behavior("Weapon")

function Weapon:initialize()
  local collider = self:addComponent("PhysicsCollider")
  collider.categories = World.layer("Weapon")
  collider.mask = 0

  self.damage = 0
  self.staminaMultiplier = 0.85

  self.movementDirection = nil

  self.hurtList = {}

  self.onApplyEffects = nil
  self.onHitConnected = nil
  self.onEnvironmentHit = nil

  self.didHitEnvironment = false

  self:on("collisionStart", function (collisionInfo)
    if collisionInfo.object._objectId == 0 then
      if self.onEnvironmentHit and not self.didHitEnvironment then
        self.didHitEnvironment = true
        self.onEnvironmentHit(collisionInfo)
      end
    end
  end)
end

function Weapon:startAttack(damage)
  self.damage = damage
  self.hurtList = {}
  self.didHitEnvironment = false
end

function Weapon:activate()
  self.physicsCollider.mask = flags(World.layer("Hitbox"), World.layer("World"))
end

function Weapon:deactivate()
  self.physicsCollider.mask = 0
  self.hurtList = {}
  self.didHitEnvironment = false
end

function Weapon:shouldConnect(object)
  local parent = self.transform.parent
  if parent and parent.object._objectId == object._objectId then
    return false
  end

  if not self.hurtList[object._objectId] then
    self.hurtList[object._objectId] = true
    if self.onHitConnected then
      self.onHitConnected(object, self.damage)
    end

    return true
  end

  return false
end

function Weapon:listenForAnimationEvents(object, onEvent, offEvent)
  onEvent = onEvent or "AttackColliderOn"
  offEvent = offEvent or "AttackColliderOff"

  object:on("animationEvent", function(trackId, animationName, stringValue)
    if stringValue == onEvent then
      self:activate()
    elseif stringValue == offEvent then
      self:deactivate()
    end
  end)
end
