local AI = require "util/aicommon"

local Altar = Behavior("Altar")

Altar.editorIcon("altar/altar.json")

function Altar:initialize()
  local renderer = self:addComponent("SkeletonRenderer")
  renderer.skeleton = "altar/altar.json"
  renderer:setAnimation(0, "idle", true)
  renderer:enableEvents()
  renderer.zOrder = 100

  local collider = self:addComponent("PhysicsCollider")
  collider:addRectangleShape(Vector(-5.0, 20.0), Vector(210.0, 90.0))
  collider.mask = 255
  collider.categories = flags(World.layer("MovementCollider"), World.layer("Interactable"))
  collider.type = collider.Types.Static

  local soundEmitter = self:addComponent("SoundEmitter")
  soundEmitter:postEvent("AltarHum")
  
  self.range = 240.0

  self.object:on("use", function()
    Kernel.altarView:show()
  end)

  self.mainCo = Co.create(function()
    while true do
      renderer:setAnimation(0, "idle", true)

      while not self:isHeroInRange() do
        Co.sleep(1.0)
      end
      
      self.heroRef.canChangeRunes = true

      soundEmitter:postEvent("AltarActivate")
      renderer:setAnimation(0, "active_on")
      AI.yieldWaitForAnimation(self.object, "active_on")
      renderer:setAnimation(0, "idle_active", true)

      while self:isHeroInRange() do
        Co.sleep(1.0)
      end

      self.heroRef.canChangeRunes = false
      AI.yieldWaitForAnimation(self.object, "idle_active")

      soundEmitter:postEvent("AltarDeactivate")
      renderer:setAnimation(0, "active_off")
      AI.yieldWaitForAnimation(self.object, "active_off")
    end
  end)
end

function Altar:awake()
  self.heroRef = BehaviorUtil.findFirstOfType("Hero")
end

function Altar:update()
  if not self.mainCo:update() then
    self.mainCo:reset()
  end
end

function Altar:isHeroInRange()
  if not self.heroRef then
    return
  end

  return Vector.distance(self.transform.worldPosition, self.heroRef.transform.worldPosition) <= self.range
end
