local SaveGameManager = require "util/savegamemanager"

local ArenaTrophies = Behavior("ArenaTrophies")

ArenaTrophies.editorIcon("trophy/trophy.json")

function ArenaTrophies:initialize(properties)
  self.properties = ArenaTrophies.defaultProperties(properties)

  local renderer = self:addComponent("SkeletonRenderer")
  renderer.skeleton = "trophy/trophy.json"
  renderer.zOrder = 100
  renderer:setAnimation(0, "idle_empty", true)

  local collider = self:addComponent("PhysicsCollider")
  collider.type = collider.Types.Static
  collider.categories = World.layer("World")
  collider.mask = 255
  collider:addRectangleShape(Vector(0.0, 4.0), Vector(160.0, 50.0))

  SaveGameManager:on("loadGame", function(saveGame)
    local arenaInfo = saveGame:getKey("arenaInfo")
    arenaInfo = arenaInfo or { current = 0 }
    if arenaInfo.current == 0 then
      renderer:setAnimation(0, "idle_empty", true)
    elseif arenaInfo.current == 1 then
      renderer:setAnimation(0, "idle_1", true)
    elseif arenaInfo.current == 2 then
      renderer:setAnimation(0, "idle_2", true)
    elseif arenaInfo.current == 3 then
      renderer:setAnimation(0, "idle_3", true)
    end
  end)
end
