local Banner = Behavior("Banner")

Banner.property("wind", false)
Banner.editorIcon("banner/banner.json")

function Banner:initialize(properties)
  self.properties = Banner.defaultProperties(properties)

  local renderer = self:addComponent("SkeletonRenderer")
  renderer.zOrder = 100
  renderer.skeleton = "banner/banner.json"

  if self.properties.wind then
    renderer:setAnimation(0, "idle_wind", true)
  else
    renderer:setAnimation(0, "idle", true)
  end

  renderer:fastForward(Random.value() * 16.0)

  local collider = self:addComponent("PhysicsCollider")
  collider:addCircleShape(Vector(0.0, 16.0), 24.0)
  collider.type = collider.Types.Static
  collider.categories = flags(World.layer("World"), World.layer("Hitbox"))
  collider.mask = flags(World.layer("Weapon"), World.layer("MovementCollider"))

  self:on("collisionStart", function(collisionInfo)
    if not collisionInfo.object.weapon then
      return
    end

    renderer:setAnimation(0, "get_hit", false)

    if self.properties.wind then
      renderer:addAnimation(0, "idle_wind", true)
    else
      renderer:addAnimation(0, "idle", true)
    end
  end)
end

function Banner:setWind(wind)
  self.properties.wind = wind
  if self.properties.wind then
    self.skeletonRenderer:setAnimation(0, "idle_wind", true)
  else
    self.skeletonRenderer:setAnimation(0, "idle", true)
  end

  self.skeletonRenderer:fastForward(Random.value() * 8.0)
end
