local AI = require "util/aicommon"
local LootSpawner = require "util/lootspawner"

local Chest = Behavior("Chest")

Chest.editorIcon("chest/chest.json")
Chest.property("lootTable", "Chest")
Chest.property("open", false)
Chest.property("skin", "wood")

function Chest:initialize(properties)
  self.properties = Chest.defaultProperties(properties)
  local inventory = self:addComponent("Inventory")

  if self.properties.lootTable and self.properties.lootTable:len() > 0 then
    LootSpawner.evaluateTableByName(inventory, self.properties.lootTable)
  end

  local renderer = self:addComponent("SkeletonRenderer")
  renderer.skeleton = "chest/chest.json"
  renderer.skin = self.properties.skin
  renderer:enableEvents()

  if self.properties.open then
    renderer:setAnimation(0, "idle_opened", true)
  else
    renderer:setAnimation(0, "idle_closed", true)
  end

  local collider = self:addComponent("PhysicsCollider")
  collider:addRectangleShape(Vector(0.0, 16.0), Vector(64.0, 64.0))
  collider.type = collider.Types.Static
  collider.categories = flags(World.layer("MovementCollider"), World.layer("Interactable"))
  collider.mask = 255

  local soundEmitter = self:addComponent("SoundEmitter")

  local getHit = Co.create(function()
    renderer:setAnimation(0, "get_hit")

    AI.yieldWaitForAnimation(self.object, "get_hit")    

    if self.properties.open then
      renderer:setAnimation(0, "idle_opened", true)
    else
      renderer:setAnimation(0, "idle_closed", true)
    end
  end)

  self:on("collisionStart", function(collisionInfo)
    if not collisionInfo.object.weapon or self.properties.open then
      return
    end

    getHit:reset()
    self.mainCo = getHit
  end)

  self:on("use", function ()
    if self.properties.open then
      soundEmitter:postEvent("ItemPouchUse")
      
      Kernel.containerView:show(self.inventory, function()
        if self.inventory:isEmpty() then
          collider.categories = World.layer("World")
        end
      end)
    else
      self.properties.open = true
      soundEmitter:postEvent("ChestOpened")
      renderer:setAnimation(0, "open", false)
      renderer:addAnimation(0, "idle_opened", true)
    end
  end)
end

function Chest:update()
  if self.mainCo then
    if not self.mainCo:update() then
      self.mainCo = nil
    end
  end
end
