local SaveGameManager = require "util/savegamemanager"
local LootSpawner = require "util/lootspawner"

local ItemPouch = Behavior("ItemPouch")

ItemPouch.property("lootTable", "SmallGold")
ItemPouch.property("uniqueId", "")

ItemPouch.editorIcon("pouch/pouch.json")

function ItemPouch:initialize(properties)
  self.properties = ItemPouch.defaultProperties(properties)
  local inventory = self:addComponent("Inventory")

  if self.properties.lootTable and self.properties.lootTable:len() > 0 then
    LootSpawner.evaluateTableByName(inventory, self.properties.lootTable)
  end

  if self.properties.uniqueId then
    SaveGameManager:on("loadGame", function(saveGame)
      local lootedItems = saveGame:getKey("lootedItems")
      if not lootedItems then
        return
      end

      if lootedItems[self.properties.uniqueId] then
        self.object:destroy()
      end
    end)
  end

  local renderer = self:addComponent("SkeletonRenderer")
  renderer.zOrder = 100
  renderer.skeleton = "pouch/pouch.json"
  renderer:setAnimation(0, "spawn", false)
  renderer:addAnimation(0, "idle", true)
  renderer.flag = renderer.Flags.Dissolve

  local soundEmitter = self:addComponent("SoundEmitter")
  soundEmitter:postEvent("ItemPouchSpawn")

  local collider = self:addComponent("PhysicsCollider")
  collider:addCircleShape(Vector(0.0, 6.0), 10.0)
  collider.mask = 255
  collider.categories = flags(World.layer("Interactable"))
  collider.type = collider.Types.Static

  self.object:on("use", function()
    if not Kernel.containerView.visible then
      soundEmitter:postEvent("ItemPouchUse")

      Kernel.containerView:show(self.inventory, function ()
        if self.inventory:isEmpty() then
          if self.properties.uniqueId ~= "" then
            local saveGame = SaveGameManager.getCurrent()
            local lootedItems = saveGame:getKey("lootedItems") or {}
            lootedItems[self.properties.uniqueId] = true
            saveGame:setKey("lootedItems", lootedItems)
          end

          self.object:destroy()
        end
      end)
    end
  end)
end
