local PineTree = Behavior("PineTree")

PineTree.editorIcon("pinetree/pinetree.json")

function PineTree:initialize()
  local renderer = self:addComponent("SkeletonRenderer")
  renderer.zOrder = 100
  renderer.skeleton = "pinetree/pinetree.json"
  renderer:setAnimation(0, "idle", true)
  renderer:fastForward(Random.value() * 32.0)

  local collider = self:addComponent("PhysicsCollider")
  collider:addCircleShape(Vector(4.0, 40.0), 44.0)
  collider.type = collider.Types.Static
  collider.categories = flags(World.layer("World"), World.layer("Hitbox"))
  collider.mask = flags(World.layer("Weapon"), World.layer("MovementCollider"))

  self:on("collisionStart", function(collisionInfo)
    if not collisionInfo.object.weapon then
      return
    end

    renderer:setAnimation(0, "get_hit", false)
    renderer:addAnimation(0, "idle", true)
  end)
end
