local SaveGameManager = require "util/savegamemanager"

local MissionAreas = Behavior("MissionAreas")

function MissionAreas:initialize()
  self.heroRef = CreateObject("Hero", Vector.zero()):addComponent("Hero")
  Graphics.useFogOfWar(true)

  self.currentAreaIndex = 1
  SaveGameManager:on("saveGame", function(saveGame)
    saveGame:setKey("missionAreas", { current = self.currentAreaIndex })
  end)

  SaveGameManager:on("loadGame", function(saveGame)
    local missionAreas = saveGame:getKey("missionAreas")
    if missionAreas then
      self.currentAreaIndex = missionAreas.current
    end
  end)
end

function MissionAreas:awake()
  local areaIndex = self.currentAreaIndex
  if areaIndex > 9 then
    areaIndex = 1.0 + math.floor(Random.value() * 7.0)
  end

  local portalName = "Start_" .. tostring(areaIndex)
  local targetPortal = nil

  local portals = BehaviorUtil.findAllOfType("Portal")
  for i, portal in ipairs(portals) do
    if portal.properties.name == portalName then
      targetPortal = portal
    end
  end

  self.heroRef.transform.localPosition = targetPortal.transform.worldPosition
  self.heroRef.cameraFollower:snapToPosition()

  if self.currentAreaIndex < 10 then
    self.currentAreaIndex = self.currentAreaIndex + 1
  end

  self.heroAliveCo = Co.create(function()
    while true do
      if not self.heroRef.health.isAlive and
        not self.heroRef.statusEffects:hasStatusEffect("SecondChance") then
        break
      end

      Co.sleep(1.0)
    end

    local nextTimer = 4.0
    while nextTimer > 0.0 do
      self:drawText("You died. Returning to hub in " .. tostring(math.floor(nextTimer + 1.0)) .. ".")
      nextTimer = nextTimer - Time.fixedDeltaTime
      Co.yield()
    end

    Co.sleep(1.0)
    SaveGameManager.save()
    if not _EDITOR then
      World.setCurrent("worlds/demo/hub.wrld")
    end
  end)
end

function MissionAreas:update()
  if not self.heroAliveCo:update() then
    self.heroAliveCo:reset()
  end

  if not self.textCo then
    return
  end

  if not self.textCo:update() then
    self.textCo = nil
  end
end

function MissionAreas:drawText(text)
  self.textCo = Co.create(function()
    while true do
      self:drawCenteredText(text, 2.0, 120.0)
      Co.yield()
    end
  end)
end

function MissionAreas:drawCenteredText(text, scale, yPosition)
  local cameraPosition = Camera.getPosition()

  local size = Graphics.measureText(text, nil, scale)

  Graphics.drawText(text, {
    position = Camera.getSize() * 0.5 + Vector(-size.x * 0.5, yPosition) + cameraPosition,
    isUI = true,
    color = Color.black,
    scale = scale
  })
end