local ItemDefs = require "data/itemdefs"

local ItemDef = function(itemType, data)
  data.type = itemType

  if ItemDefs[data.id] then
    print("WARNING! Duplicate item identifier \"" .. data.id .. "\", second definition will be ignored.")
    return
  end

  ItemDefs[data.id] = data
end

local POTION_ITEM = function(data)
  ItemDef("Potion", data)
end

local KEY_ITEM = function(data)
  ItemDef("KeyItem", data)
end

local RUNE_ITEM = function(data)
  ItemDef("Rune", data)
end

local RESOURCE_ITEM = function(data)
  ItemDef("Resource", data)
end

-- -- EDIT BELOW THIS LINE -- --

-- POTIONS --

POTION_ITEM {
  id = "HealingPotion",
  name = "Healing Potion",
  desc = [[
    A small quantity of rejuvenating serum.
    Heals you for a small amount of HP.
  ]],
  icon = "item-icon hp-small",
  handler = "Healing",
  amount = 50.0,
  duration = 2.5,
  cost = 50
}

POTION_ITEM {
	id = "GreaterHealingPotion",
	name = "Greater Healing Potion",
	desc = [[
    A larger quantity of rejuvenating serum.
    Heals you for a moderate amount of HP.
  ]],
  icon = "item-icon hp-large",
  handler = "Healing",
  amount = 150.0,
  duration = 7.5,
  cost = 100
}

POTION_ITEM {
	id = "StaminaPotion",
	name = "Stamina Potion",
	desc = [[
    ST usage by attacks and abilities dropped by half. Effect lasts for a moderate duration.
  ]],
  icon = "item-icon stamina-small",
  handler = "BoostStaminaRegen",
  duration = 30.0,
  multiplier = 0.5,
  cost = 50
}

POTION_ITEM {
  id = "GreaterStaminaPotion",
  name = "Greater Stamina Potion",
  desc = [[
    ST usage by attacks and abilities dropped by half. Effect lasts for a long duration.
  ]],
  icon = "item-icon stamina-large",
  handler = "BoostStaminaRegen",
  duration = 60.0,
  multiplier = 0.5,
  cost = 150
}

POTION_ITEM {
  id = "Berserk",
  name = "Berserk",
  desc = [[
    Increases the damage you deal, but also the damage you take for a moderate duration.
  ]],
  icon = "item-icon berserk",
  handler = "Berserk",
  duration = 90.0,
  cost = 300
}

POTION_ITEM {
  id = "SecondChance",
  name = "Second Chance",
  desc = [[
    You get resurrected once after you die.
  ]],
  icon = "item-icon second-chance",
  handler = "SecondChance",
  cost = 1200
}

POTION_ITEM {
  id = "InvisibilityPotion",
  name = "Invisibility Potion",
  desc = [[
    Turn almost completely invisible. Enemies have a hard time noticing you.
  ]],
  icon = "item-icon invisibility",
  handler = "Invisibility",
  duration = 60.0,
  cost = 600
}

-- RESOURCES --
RESOURCE_ITEM {
  id = "RuneShard",
  name = "Rune Shard",
  desc = [[
    A broken shard from an ancient Rune.
  ]],
  icon = "item-icon rune-shard",
  cost = 500
}

-- RUNES --

RUNE_ITEM {
  id = "Cloverleaf",
  name = "Cloverleaf",
  desc = [[
    Increases item drop chance.
  ]],
  icon = "rune-icon cloverleaf",
  cost = 2000,
  shardCost = 4
}

RUNE_ITEM {
  id = "EldrichInsanity",
  name = "Eldrich Insanity",
  desc = [[
    Small chance that after hitting you a mob will turn to your side.
  ]],
  icon = "rune-icon eldrich-insanity",
  cost = 2000,
  shardCost = 4
}

RUNE_ITEM {
  id = "EnergySurge",
  name = "Energy Surge",
  desc = [[
    Deal 150% DMG when under 30% HP.
  ]],
  icon = "rune-icon energy-surge",
  cost = 1500,
  shardCost = 3
}

RUNE_ITEM {
  id = "Focused",
  name = "Focused",
  desc = [[
    50% chance that attacks don't use ST.
  ]],
  icon = "rune-icon focused",
  cost = 2000,
  shardCost = 4
}

RUNE_ITEM {
  id = "ElsasTouch",
  name = "Elsa's Touch",
  desc = [[
    25% chance to freeze an enemy on hit.
  ]],
  icon = "rune-icon elsas-touch",
  cost = 2000,
  shardCost = 4
}

RUNE_ITEM {
  id = "Knighted",
  name = "Knighted",
  desc = [[
    Blocking takes less ST.
  ]],
  icon = "rune-icon knighted",
  cost = 1500,
  shardCost = 3
}

RUNE_ITEM {
  id = "Lighting",
  name = "Lighting",
  desc = [[
    Greatly increased movement speed. Movement now costs ST.
  ]],
  icon = "rune-icon lighting",
  cost = 2000,
  shardCost = 4
}

RUNE_ITEM {
  id = "Vampirism",
  name = "Lifedrain",
  desc = [[
    Drain HP from enemies on a successful attack.
  ]],
  icon = "rune-icon vampirism",
  cost = 2000,
  shardCost = 4
}

RUNE_ITEM {
  id = "StarTwin",
  name = "Star Twin",
  desc = [[
    Summon a second you. Your avatar has 1/3 of your HP. 15 seconds cooldown when your avatar dies.
  ]],
  icon = "rune-icon star-twin",
  cost = 2500,
  shardCost = 5
}

RUNE_ITEM {
  id = "Venom",
  name = "Venom",
  desc = [[
    Your attacks poison enemies for 10% of the attack's damage per second for 5 seconds.
  ]],
  icon = "rune-icon venom",
  cost = 2000,
  shardCost = 4
}

RUNE_ITEM {
  id = "Dragonshout",
  name = "Dragonshout",
  desc = [[
    Your Evade move is replaced with a powerful shout which creates a shockwave that knocks nearby enemies away.
  ]],
  icon = "rune-icon dragonshout",
  cost = 2500,
  shardCost = 5
}

RUNE_ITEM {
  id = "Guzzler",
  name = "Guzzler",
  desc = [[
    Getting attacked while consuming a potion does not cancel it.
  ]],
  icon = "rune-icon guzzler",
  cost = 2000,
  shardCost = 4
}

RUNE_ITEM {
  id = "SprintBurst",
  name = "Sprint Burst",
  desc = [[
    140% movement speed for 2 seconds after getting hit.
  ]],
  icon = "rune-icon sprint-burst",
  cost = 2000,
  shardCost = 4
}

RUNE_ITEM {
  id = "Farsight",
  name = "Farsight",
  desc = [[
    You see can see things from farther away.
  ]],
  icon = "rune-icon farsight",
  cost = 1500,
  shardCost = 3
}

RUNE_ITEM {
  id = "Bloodthirst",
  name = "Bloodthirst",
  desc = [[
    Attacks cost no ST, but missed hits take HP.
  ]],
  icon = "rune-icon bloodthirst",
  cost = 1500,
  shardCost = 3
}

RUNE_ITEM {
  id = "Coldblooded",
  name = "Coldblooded",
  desc = [[
    Enemies get slowed when they hit you.
  ]],
  icon = "rune-icon coldblooded",
  cost = 1500,
  shardCost = 3
}

RUNE_ITEM {
  id = "BarrelCrasher",
  name = "Barrel Crasher",
  desc = [[
    Destructible objects always get destroyed on the first hit.
  ]],
  icon = "rune-icon barrel-crasher",
  cost = 1500,
  shardCost = 3
}

RUNE_ITEM {
  id = "SecondWind",
  name = "Second Wind",
  desc = [[
    25% chance to fully recover ST when it hits zero.
  ]],
  icon = "rune-icon second-wind",
  cost = 1500,
  shardCost = 3
}

RUNE_ITEM {
  id = "Relentless",
  name = "Relentless",
  desc = [[
    After depleting ST attacks will take HP instead but you don't go out of breath.
  ]],
  icon = "rune-icon relentless",
  cost = 2000,
  shardCost = 4
}

RUNE_ITEM {
  id = "Tough",
  name = "Tough",
  desc = [[
    Increases base HP by 65.
  ]],
  icon = "rune-icon tough",
  cost = 1500,
  shardCost = 3
}
