local Item = function(itemId, minQty, maxQty, chance)
  return { type = "item", id = itemId, minQty = minQty, maxQty = maxQty, chance = chance }
end

local Gold = function(minQty, maxQty, chance)
  return { type = "gold", minQty = minQty, maxQty = maxQty, chance = chance }
end

local Loot = {}

Loot.SmallGold = {
  Gold(10, 100, 1.0)
}

Loot.Chest = {
  Gold(10, 150, 1),
  Item("RuneShard", 1, 1, 0.5);
}

Loot.EndOfSegmentChest = {
  Gold(100, 100, 1.0),
  Gold(200, 300, 0.25),
  Gold(500, 1000, 0.02),
  Item("RuneShard", 1, 1, 1.0),
  Item("RuneShard", 1, 1, 0.05),
  Item("GreaterHealingPotion", 1, 1, 0.15),
  Item("SecondChance", 1, 1, 0.04)
}

Loot.ArenaMob = {
  Gold(10, 30, 0.5),
  Item("HealingPotion", 1, 1, 0.15),
  Item("StaminaPotion", 1, 1, 0.15),
  Item("GreaterHealingPotion", 1, 1, 0.066),
  Item("GreaterStaminaPotion", 1, 1, 0.066),
  Item("RuneShard", 1, 1, 0.033)
}

Loot.ArenaBoss = {
  Gold(100, 500, 1.0),
  Item("RuneShard", 1, 3, 1.0),
  Item("SecondChance", 1, 1, 1.0)
}

Loot.ArenaBarrel = {
  Gold(1, 10, 0.25),
  Item("HealingPotion", 1, 1, 0.01)
}

Loot.Barrel = {
  Gold(10, 20, 0.5),
  Item("HealingPotion", 1, 1, 0.05),
  Item("GreaterHealingPotion", 1, 1, 0.01)
}

Loot.HubRuneTough = {
	Item("Tough", 1, 1, 1.0)
}

Loot.HubRuneGuzzler = {
	Item("Guzzler", 1, 1, 1.0)
}

Loot.GrindRuneBarrelCrasher = {
  Item("BarrelCrasher", 1, 1, 1.0),
}

Loot.Draugur = {
  Gold(15, 30, 0.75),
  Item("HealingPotion", 1, 1, 0.15),
  Item("StaminaPotion", 1, 1, 0.15)
}

Loot.Mori = {
  Gold(10, 40, 0.75)
}

Loot.Knight = {
  Gold(30, 70, 0.75),
  Item("HealingPotion", 1, 1, 0.15),
  Item("StaminaPotion", 1, 1, 0.15),
  Item("GreaterHealingPotion", 1, 1, 0.05),
  Item("GreaterStaminaPotion", 1, 1, 0.05),
  Item("Berserk", 1, 1, 0.03),
  Item("InvisibilityPotion", 1, 1, 0.03),
  Item("SecondChance", 1, 1, 0.01)
}

Loot.Preacher = {
  Gold(15, 45, 0.75),
  Item("HealingPotion", 1, 1, 0.15),
  Item("StaminaPotion", 1, 1, 0.15),
  Item("GreaterHealingPotion", 1, 1, 0.05),
  Item("GreaterStaminaPotion", 1, 1, 0.05)
}

Loot.LittleAssassin = {
  Gold(20, 40, 0.75),
  Item("HealingPotion", 1, 1, 0.15),
  Item("StaminaPotion", 1, 1, 0.15),
  Item("GreaterHealingPotion", 1, 1, 0.05),
  Item("GreaterStaminaPotion", 1, 1, 0.05)
}

Loot.ForestCritter = {
}

Loot.CloverleafRune = {
  Item("Cloverleaf", 1, 1, 1.0)
}

Loot.EnergySurgeRune = {
  Item("EnergySurge", 1, 1, 1.0)
}

Loot.RuneShard = {
  Item("RuneShard", 20, 20, 1.0)
}

Loot.WonderBarrel = {
  Gold(10, 20, 1.0),
  Item("Cloverleaf", 1, 1, 0.33)
}

Loot.AllPotions = {
  Item("HealingPotion", 10, 10, 1.0),
  Item("StaminaPotion", 10, 10, 1.0),
  Item("GreaterHealingPotion", 10, 10, 1.0),
  Item("GreaterStaminaPotion", 10, 10, 1.0)
}

Loot.AllRunes = {
  Item("HealingPotion", 10, 10, 1.0),
  Item("Cloverleaf", 1, 1, 1.0),
  Item("EldrichInsanity", 1, 1, 1.0),
  Item("EnergySurge", 1, 1, 1.0),
  Item("Focused", 1, 1, 1.0),
  Item("ElsasTouch", 1, 1, 1.0),
  Item("Knighted", 1, 1, 1.0),
  Item("Lighting", 1, 1, 1.0),
  Item("Vampirism", 1, 1, 1.0),
  Item("StarTwin", 1, 1, 1.0),
  Item("Venom", 1, 1, 1.0),
  Item("Dragonshout", 1, 1, 1.0),
  Item("Guzzler", 1, 1, 1.0),
  Item("SprintBurst", 1, 1, 1.0),
  Item("Farsight", 1, 1, 1.0),
  Item("Bloodthirst", 1, 1, 1.0),
  Item("Coldblooded", 1, 1, 1.0),
  Item("BarrelCrasher", 1, 1, 1.0),
  Item("SecondWind", 1, 1, 1.0),
  Item("Relentless", 1, 1, 1.0),
  Item("Tough", 1, 1, 1.0)
}

return Loot
