local Console = EditorBehavior("Console")

function Console:initialize()
  self.visible = false
  self.consoleLog = {}
  self.consoleLogLength = 0
  self.consoleInput = ""
  self.execute = false
  
  local oldPrint = print
  print = function(message)
    if message == nil then
      return
    end
    
    if type(message) ~= "string" then
      message = inspect(message)
    end
    
    self.consoleLog[self.consoleLogLength] = message
    self.consoleLogLength = self.consoleLogLength + 1
    oldPrint(message)
  end
end

function Console:update(deltaTime)
  if self.execute then
    self.execute = false
    local input = self.consoleInput
    self.consoleInput = ""
    print(input)
    _L._debugDoString("print(" .. input .. ")")
  end

  if self.visible then
    self:drawWindow()
  end
end

function Console:drawWindow()
  self.visible = EditorUI.beginWindowMenubar("Console", 800, 300)
  
  if self.visible then
    if EditorUI.beginMenuBar() then
      if EditorUI.beginMenu("Options") then
        if EditorUI.menuItem("Clear") then
          self.consoleLog = {}
          self.consoleLogLength = 0
        end
        
        EditorUI.endMenu()
      end
      
      EditorUI.endMenuBar()
    end
    
    EditorUI.beginScroll("ConsoleLog")
    
    for i = 0, self.consoleLogLength - 1 do
      EditorUI.textUnformatted(self.consoleLog[i])
    end
    EditorUI.setScrollPosHere()
    
    EditorUI.endScroll()
    EditorUI.separator()
    
    EditorUI.inputText("Command", self.consoleInput, 64, function(text)
      self.consoleInput = text
      self.execute = true
    end)
  end
  
  EditorUI.endWindow()
end

