local EditorSettings = EditorBehavior("EditorSettings")

function EditorSettings:initialize()
  self.visible = false
  
  local w, h = _L._screenGetResolution()
  self.resolution = Vector(w, h)
  self.fullscreen = _L._screenIsFullscreen()
end

function EditorSettings:update(deltaTime)
  if self.visible then
    self:drawWindow()
  end
end

function EditorSettings:drawWindow()
  self.visible = EditorUI.beginWindow("Settings", self.visible, 400, 300)
  
  if not self.visible then
    EditorUI.endWindow()
    return
  end
  
  self.fullscreen = EditorUI.checkbox("Fullscreen", self.fullscreen)

  EditorUI.text("Resolution: " .. tostring(self.resolution.x) .. "x" .. tostring(self.resolution.y))

  if EditorUI.button("Change resolution") then
    EditorUI.openPopup("ChangeResolutionPopup")
  end

  if EditorUI.beginPopup("ChangeResolutionPopup") then
    local modes = {}
    _L._screenGetAvailableResolutions(modes)

    for i, mode in ipairs(modes) do
      if EditorUI.selectable(tostring(mode.width) .. "x" .. tostring(mode.height) .. "@" .. tostring(mode.refreshRate)) then
        self.resolution = Vector(mode.width, mode.height)
        _L._screenSetResolution(self.resolution.x, self.resolution.y, self.fullscreen)
      end
    end

    EditorUI.endPopup()
  end
  
  EditorUI.endWindow()
end
