local GlobalConfig = EditorBehavior("GlobalConfig")

function GlobalConfig:initialize()
  self.visible = false
end

function GlobalConfig:update(deltaTime)
  if self.visible then
    self:drawWindow()
  end
end

function GlobalConfig:drawWindow()
  self.visible = EditorUI.beginWindow("Global configuration", self.visible, 200, 300)
  
  if not self.visible then
    EditorUI.endWindow()
    return
  end 
  
  if EditorUI.button("Save") then
    Config.save()
  end
  
  EditorUI.sameLine()
  
  if EditorUI.button("Load") then
    Config.load()
  end
  
  local categories = Config.getKeys()

  for categoryName, items in spairs(categories) do
    if EditorUI.collapsingHeader(categoryName, false) then 
      for key, v in spairs(items) do
        if v.type == "int" then
          local newInt = EditorUI.inputInt(key, v.value, 1)
          if newInt ~= v.value then
            Config.setKey(categoryName, key, v.type, newInt)
          end
        elseif v.type == "float" then
          local newFloat = EditorUI.inputFloat(key, v.value, 0.01)
          if newFloat ~= v.value then
            Config.setKey(categoryName, key, v.type, newFloat)
          end
        elseif v.type == "bool" then
          local newBool = EditorUI.checkbox(key, v.value)
          if newBool ~= v.value then
            Config.setKey(categoryName, key, v.type, newBool)
          end
        elseif v.type == "string" then
          local newString = EditorUI.inputText(key, v.value, 32)
          if newString ~= v.value then
            Config.setKey(categoryName, key, v.type, newString)
          end
        end
      end
    end
  end
  
  EditorUI.endWindow()
end
