local ProfilerLib = require "lib/profiler"

local Profiler = EditorBehavior("Profiler")

function Profiler:initialize()
  self.running = false
end

function Profiler:update(deltaTime)
  if not self.visible then
    return
  end
  
  self:drawWindow()
end

function Profiler:drawWindow()
  self.visible = EditorUI.beginWindowMenubar("Profiler", 800, 300)
  
  if self.visible then
    if not self.running then
      if EditorUI.button("Start") then
        ProfilerLib.start()
        self.running = true
        self.samples = nil
      end
    else
      if EditorUI.button("Stop") then
        ProfilerLib.stop()
        self.running = false
        local profSamples = ProfilerLib.getSamples()

        self.samples = {}
        for path, samples in pairs(profSamples) do
          self.samples[#self.samples+1] = { path = path, samples = samples }
        end

        table.sort(self.samples, function(a, b)
          return a.samples > b.samples
        end)
      end
    end

    if self.samples then
      for i, data in pairs(self.samples) do
        EditorUI.text(data.path .. " - " .. tostring(data.samples))
      end
    end
  end

  EditorUI.endWindow()
end
