local SceneGraph = EditorBehavior("SceneGraph")

function SceneGraph:initialize()
  self.visible = false
end

function SceneGraph:update(deltaTime)
  if self.visible then
    self:drawWindow()
  end
end

function SceneGraph:drawWindow()
  self.visible = EditorUI.beginWindow("Scene Graph", self.visible, 300, 600)
  
  if not self.visible then
    EditorUI.endWindow()
    return
  end
  
  EditorUI.separator()
  
  local selectedObjectId = 0
  if self.componentEditor.object ~= nil then
    selectedObjectId = self.componentEditor.object._objectId
  end

  local objects = {}
  _L._debugGetWorldObjects(objects)
  
  for id, name in pairs(objects) do
    local object = WorldObject(id)
    
    if object ~= nil then
      if object.transform:getParent() == nil then
        self:drawObject(selectedObjectId, object)
      end
    end
  end
  
  EditorUI.endWindow()
end

function SceneGraph:drawObject(selectedObjectId, object)
  if EditorUI.selectable("#" .. object:getId() .. " " .. object:getName(), selectedObjectId == object:getId()) then
    self.componentEditor.object = object
    self.componentEditor.visible = true
  end

  if EditorUI.isItemHovered() then
    local position = object.transform:getWorldPosition()
    local scale = object.transform:getWorldScale()
    Debug.drawLine(Input.getMouseWorldPosition(), position, 0XFFFFFFFF)

    local bounds = object.transform:getWorldBounds()
    Debug.drawRect(bounds.bottomLeft, bounds.topRight - bounds.bottomLeft, 0xFFFF00FF)
  end

  local children = object.transform:getChildren()
  if #children > 0 then
    if EditorUI.treeNode("Children", "Chilren_" .. tostring(object:getId())) then
        for i, child in ipairs(children) do
          self:drawObject(selectedObjectId, child)
        end
      EditorUI.treePop()
    end
  end
end
