local SoundTest = EditorBehavior("SoundTest")

function SoundTest:initialize()
  self.visible = false
  self.testParam = 0.0
  
  self.masterVolume = 50.0
  self.musicVolume = 50.0
  self.sfxVolume = 50.0
  self.ambientVolume = 50.0
end

function SoundTest:update(deltaTime)
  if not self.visible then
    return
  end

  Kernel.soundEmitter:setRTPC("TestParameter", self.testParam, true)
  Kernel.soundEmitter:setRTPC("MasterVolume", self.masterVolume, true)
  Kernel.soundEmitter:setRTPC("MusicVolume", self.musicVolume, true)
  Kernel.soundEmitter:setRTPC("SfxVolume", self.sfxVolume, true)
  Kernel.soundEmitter:setRTPC("AmbientVolume", self.ambientVolume, true)
  
  self:drawWindow()
end

function SoundTest:drawWindow()
  self.visible = EditorUI.beginWindowMenubar("Sound Test", 800, 300)
  
  if self.visible then
    self.testParam = EditorUI.sliderFloat("TestParameter", self.testParam, 0.0, 100.0)
    self.masterVolume = EditorUI.sliderFloat("Master volume", self.masterVolume, 0.0, 100.0)
    self.musicVolume = EditorUI.sliderFloat("Music volume", self.musicVolume, 0.0, 100.0)
    self.sfxVolume = EditorUI.sliderFloat("Sfx volume", self.sfxVolume, 0.0, 100.0)
    self.ambientVolume = EditorUI.sliderFloat("Ambient volume", self.ambientVolume, 0.0, 100.0)
  end
  
  EditorUI.endWindow()
end

