local Stats = EditorBehavior("Stats")

function Stats:initialize()
  self.visible = false
  self.frameAccumulator = 0
  self.timeAccumulator = 0.0
  self.averageFps = 0.0
  self.resetCycle = 0
end

function Stats:update(deltaTime)
  self.timeAccumulator = self.timeAccumulator + deltaTime
  self.frameAccumulator = self.frameAccumulator + 1

  if self.timeAccumulator > 0.0 then
    self.resetCycle = self.resetCycle + 1
    if self.resetCycle > 32 then
      self.frameAccumulator = 0
      self.timeAccumulator = 0.0
      self.resetCycle = 0
    else
      self.averageFps = self.frameAccumulator / self.timeAccumulator
    end
  end
  
  if self.visible then
    self:drawWindow()
  end
end

function Stats:drawWindow()
  self.visible = EditorUI.beginWindow("Statistics", self.visible, 200, 140)
  
  if not self.visible then
    EditorUI.endWindow()
    return
  end 
  
  if EditorUI.collapsingHeader("Rendering") then  
    local stats = {}
    _L._debugGetRenderStats(stats)
    
    EditorUI.text("Tiles (tris): " .. stats.tileTriangles)
    EditorUI.text("Tiles (draw calls): " .. stats.tileDrawCalls)
    EditorUI.text("Sprites (tris): " .. stats.spriteTriangles)
    EditorUI.text("Sprites (draw calls): " .. stats.spriteDrawCalls)
    EditorUI.text("Postprocess (draw calls): " .. stats.postprocessDrawCalls)
    EditorUI.text("Total (draw calls): " .. (stats.tileDrawCalls + stats.spriteDrawCalls + stats.postprocessDrawCalls))
    EditorUI.text("Average frames/ sec.: " .. string.format("%.2f", self.averageFps))
  end
  
  if EditorUI.collapsingHeader("Scripts") then
    EditorUI.text("Memory: " .. string.format("%.2f", collectgarbage("count") / 1024.0) .. " MiB")
  end
  
  if EditorUI.collapsingHeader("Physics") then
    local stats = {}
    _L._debugGetPhysicsStats(stats)
    
    EditorUI.text("Bodies: " .. stats.numBodies)
    EditorUI.text("Contacts: " .. stats.numContacts)
  end
  
  EditorUI.endWindow()
end
