local _L = _L

local Asset = require "lib/asset/asset"
local Image = require "lib/asset/image"

local Spritesheet = Class(Asset)

function Spritesheet:construct(ptr)
  Asset.construct(self, ptr)
end

function Spritesheet:getTileCount()
  return _L._spritesheetGetTileCount(self._ptr)
end

function Spritesheet:getTileSize()
  local x, y = _L._spritesheetGetTileSize(self._ptr)
  return Vector(x, y)
end

function Spritesheet:getImage()
  local imagePtr = _L._spritesheetGetImage(self._ptr)
  if imagePtr ~= nil then
    return Image(imagePtr)
  end
  
  return nil
end

function Spritesheet:getSprites()
  local sprites = {}
  _L._spritesheetGetSprites(self._ptr, sprites)

  for i, sprite in ipairs(sprites) do
    sprites[i].position = Vector(sprites[i].position)
    sprites[i].size = Vector(sprites[i].size)
  end

  return sprites
end

function Spritesheet:getSprite(name)
  local sprite = {}
  _L._spritesheetGetSprite(self._ptr, name, sprite)
  sprite.position = Vector(sprite.position)
  sprite.size = Vector(sprite.size)
  return sprite
end

return Spritesheet
