local _L = _L

local Asset = require "lib/asset/asset"

local World = Class(Asset)

function World.setCurrent(world)
  _L._worldSetCurrent(world)
end

function World.getCurrent()
  local world = _L._worldGetCurrent()
  if world == nil then
    return nil
  end

  return World(world)
end

function World.isLoaded()
  return _L._worldIsLoaded()
end

function World:construct(ptr)
  Asset.construct(self, ptr)
end

function World:getSize()
  local w, h = _L._worldGetSize(self._ptr)
  return Vector(w, h)
end

function World:getTileSize()
  local w, h = _L._worldGetTileSize(self._ptr)
  return Vector(w, h)
end

function World:getPixelSize()
  return self:getSize() * self:getTileSize()
end

function World:sampleCollisionLayer(x, y)
  return _L._worldSampleCollisionLayer(self._ptr, x, y)
end

function World:getLayerCount()
  return _L._worldGetLayerCount(self._ptr)
end

function World:getScriptorCount()
  return _L._worldGetScriptorCount(self._ptr)
end

function World:getScriptor(index)
  local scriptor = {}
  _L._worldGetScriptor(self._ptr, index, scriptor)
  return scriptor
end

function World:getTriggerCount()
  return _L._worldGetTriggerCount(self._ptr)
end

function World:getTrigger(index)
  local trigger = {}
  _L._worldGetTrigger(self._ptr, index, trigger)
  return trigger
end

function World:getLandmarkCount()
  return _L._worldGetLandmarkCount(self._ptr)
end

function World:getLandmark(index)
  local landmark = {}
  _L._worldGetLandmark(self._ptr, index, landmark)
  return landmark
end

function World:getRouteCount()
  return _L._worldGetRouteCount(self._ptr)
end

function World:getRoute(index)
  local route = {}
  _L._worldGetRoute(self._ptr, index, route)
  return route
end

function World.layer(name)
  return _L._worldConfigLayerNameToMask(name)
end

function World.layerIndexToName(index)
  return _L._worldConfigLayerIndexToName(index)
end

function World.layerNameToIndex(name)
  return _L._worldConfigLayerNameToIndex(name)
end

function World.getLayerCount()
  return _L._worldConfigLayerCount()
end

return World
