local _L = _L

local Image = require "lib/asset/image"
local Spritesheet = require "lib/asset/spritesheet"
local Font = require "lib/asset/font"

AssetUtil = {}

function AssetUtil.find(path)
  local assetPtr = _L._assetFind(path)
  if assetPtr == nil then
    print("Warning! AssetUtil failed to find " .. path)
    return nil
  end
  
  local assetType = _L._assetGetType(assetPtr)
  
  if assetType == "Image" then
    return Image(assetPtr)
  elseif assetType == "Spritesheet" then
    return Spritesheet(assetPtr)
  elseif assetType == "Font" then
    return Font(assetPtr)
  elseif assetType == "SpineSkeleton" then
    return Skeleton(assetPtr)
  else
    print("Error! AssetUtil.find: Invalid asset type - " .. assetType)
  end
  
  return nil
end

function AssetUtil.getById(id)
  if id == 0 then
    return nil
  end

  local assetPtr = _L._assetGetById(id)
  if assetPtr == nil then
    return nil
  end
  
  local assetType = _L._assetGetType(assetPtr)
  
  if assetType == "Image" then
    return Image(assetPtr)
  elseif assetType == "Spritesheet" then
    return Spritesheet(assetPtr)
  elseif assetType == "Font" then
    return Font(assetPtr)
  elseif assetType == "SpineSkeleton" then
    return Skeleton(assetPtr)
  else
    print("Error! AssetUtil.find: Invalid asset type - " .. assetType)
  end
  
  return nil
end

function AssetUtil.cache(id)
  return _L._assetCache(id)
end

AssetUtil = ReadOnlyClass(AssetUtil, "AssetUtil")
