BehaviorUtil = {}

function BehaviorUtil.findAllOfType(behaviorName)
  local behaviors = {}
  
  for objectId, behaviorList in pairs(_behaviorInstances) do
    for behaviorType, behaviorInstance in pairs(behaviorList) do
      if behaviorInstance._name == behaviorName then
        table.push(behaviors, behaviorInstance)
      end
    end
  end
  
  return behaviors
end

function BehaviorUtil.findFirstOfType(behaviorName)
  local behavior = nil
  
  for objectId, behaviorList in pairs(_behaviorInstances) do
    for behaviorType, behaviorInstance in pairs(behaviorList) do
      if behaviorInstance._name == behaviorName then
        return behaviorInstance
      end
    end
  end
  
  return nil
end

BehaviorUtil = ReadOnlyClass(BehaviorUtil, "BehaviorUtil")
