local _L = _L

Camera = {}

function Camera.getPosition()
  local x, y = _L._cameraGetPosition()
  return Vector(x, y)
end

function Camera.setPosition(position)
  _L._cameraSetPosition(position.x, position.y)
end

function Camera.resetPosition(position)
  _L._cameraSetPosition(position.x, position.y)
  _L._cameraResetPosition()
end

function Camera.getSize()
  local w, h = _L._cameraGetSize()
  return Vector(w, h)
end

function Camera.setSize(size)
  _L._cameraSetSize(size.x, size.y)
end

function Camera.screenToWorld(screenPosition)
  return screenPosition + Camera.getPosition()
end

function Camera.worldToScreen(worldPosition)
  return worldPosition - Camera.getPosition()
end

Camera = ReadOnlyClass(Camera, "Camera")
