function Class(super)
  super = super or {}
  
  local class = {}
  for k, v in pairs(super) do
    if k == "construct" then
      rawset(class, "__super", rawget(super, k))
    else
      rawset(class, k, rawget(super, k))
    end
  end
  
  setmetatable(class, {
    __call = function(_, ...)
      local instance = {}
      setmetatable(instance, { __index = class })
      instance:construct(...)
      
      return instance
    end
  })

  return class
end