Color = {}
Color.__index = Color

function Color.__add(a, b)
  if type(a) == "number" then
    return Color.new(b.r + a, b.g + a, b.b + a, b.a + a)
  elseif type(b) == "number" then
    return Color.new(a.r + b, a.g + b, a.b + b, a.a + b)
  else
    return Color.new(a.r + b.r, a.g + b.g, a.b + b.b, a.a + b.a)
  end
end

function Color.__sub(a, b)
  if type(a) == "number" then
    return Color.new(a - b.r, a - b.g, a - b.b, a - b.a)
  elseif type(b) == "number" then
    return Color.new(a.r - b, a.g - b, a.b - b, a.a - b)
  else
    return Color.new(a.r - b.r, a.g - b.g, a.b - b.b, a.a - b.a)
  end
end

function Color.__mul(a, b)
  if type(a) == "number" then
    return Color.new(b.r * a, b.g * a, b.b * a, b.a * a)
  elseif type(b) == "number" then
    return Color.new(a.r * b, a.g * b, a.b * b, a.a * b)
  else
    return Color.new(a.r * b.r, a.g * b.g, a.b * b.b, a.a * b.a)
  end
end

function Color.__div(a, b)
  if type(a) == "number" then
    return Color.new(a / b.r, a / b.g, a / b.b, a / b.a)
  elseif type(b) == "number" then
    return Color.new(a.r / b, a.g / b, a.b / b, a.a / b)
  else
    return Color.new(a.r / b.r, a.g / b.g, a.b / b.b, a.a / b.a)
  end
end

function Color.__tostring(a)
  return "(" .. a.r .. ", " .. a.g .. ", " .. a.b .. ", " .. a.a .. ")"
end

function Color.new(r, g, b, a)
  return setmetatable({ r = r or 1.0, g = g or r, b = b or r, a = a or r }, Color)
end

function Color:clone()
  return Color.new(self.r, self.g, self.b, self.a)
end

function Color:mix(other, alpha)
  return self * (1.0 - alpha) + other * alpha
end

setmetatable(Color, { __call = function(_, ...) return Color.new(...) end })

Color.white = Color(1.0, 1.0, 1.0, 1.0)
Color.black = Color(0.0, 0.0, 0.0, 1.0)
Color.magenta = Color(1.0, 0.0, 1.0, 1.0)
Color.red = Color(1.0, 0.0, 0.0, 1.0) 
Color.green = Color(0.0, 1.0, 0.0, 1.0)
Color.blue = Color(0.0, 0.0, 1.0, 1.0)
