return function ()
  local component = {}

  setmetatable(component, {
    __call = function(_, ...)
      local instance = {}
      local getterCache = {}
      local setterCache = {}

      setmetatable(instance, {
        __index = function(t, k)
          if k == "worldPosition" then
            return component.getWorldPosition(instance)
          elseif k == "construct" then
            return rawget(component, "construct")
          end

          if not getterCache[k] then
            getterCache[k] = 'get' .. k:firstToUpper()
          end

          local getter = rawget(component, getterCache[k])
          if getter then
            return getter(t)
          end

          local baseFn = rawget(component, k)
          if baseFn then
            return baseFn
          end

          return rawget(t, k)
        end,
        __newindex = function(t, k, v)
          if not setterCache[k] then
            setterCache[k] = 'set' .. k:firstToUpper()
          end

          local setter = rawget(component, setterCache[k])
          if setter then
            setter(t, v)
            return
          end

          rawset(t, k, v)
        end,
      })

      instance:construct(...)
      return instance
    end
  })

  return component
end
