local _L = _L

local Component = require "lib/components/component"

-- LightSource --

local LightSource = Component()

function LightSource:construct(object, ptr)
  self._objectId = object._objectId
  self.object = object

  self._ptr = ptr
  self._name = "LightSource"
end

function LightSource:isEnabled()
  return _L._componentIsEnabled(self._ptr)
end

function LightSource:setEnabled(enabled)
  _L._componentSetEnabled(self._ptr, enabled)
end

function LightSource:getSize()
  return _L._lightSourceGetSize(self._ptr)
end

function LightSource:setSize(size)
  _L._lightSourceSetSize(self._ptr, size)
end

function LightSource:getShadowStrength()
  return _L._lightSourceGetShadowStrength(self._ptr)
end

function LightSource:setShadowStrength(shadowStrength)
  _L._lightSourceSetShadowStrength(self._ptr, shadowStrength)
end

function LightSource:getColor()
  local r, g, b, a = _L._lightSourceGetColor(self._ptr)
  return Color(r, g, b, a)
end

function LightSource:setColor(color)
  _L._lightSourceSetColor(self._ptr, color)
end

function LightSource:getAmbientIntensity()
  return _L._lightSourceGetAmbientIntensity(self._ptr)
end

function LightSource:setAmbientIntensity(intensity)
  return _L._lightSourceSetAmbientIntensity(self._ptr, intensity)
end

return LightSource
