local _L = _L

local Component = require "lib/components/component"

-- ParticleEmitter --

local ParticleEmitter = Component()

function ParticleEmitter:construct(object, ptr)
  self._objectId = object._objectId
  self.object = object

  self._ptr = ptr
  self._name = "ParticleEmitter"
end

function ParticleEmitter:isEnabled()
  return _L._componentIsEnabled(self._ptr)
end

function ParticleEmitter:setEnabled(enabled)
  _L._componentSetEnabled(self._ptr, enabled)
end

function ParticleEmitter:setMaxParticleCount(count)
  _L._particleEmitterSetMaxParticleCount(self._ptr, count)
end

function ParticleEmitter:getImage()
  return _L._particleEmitterGetImage(self._ptr)
end

function ParticleEmitter:setImage(spritesheetName)
  return _L._particleEmitterSetImage(self._ptr, spritesheetName)
end

function ParticleEmitter:getSprite()
  return _L._particleEmitterGetSprite(self._ptr)
end

function ParticleEmitter:setSprite(spriteName)
  return _L._particleEmitterSetSprite(self._ptr, spriteName)
end

function ParticleEmitter:spawnParticles(position, count)
  return _L._particleEmitterSpawnParticles(self._ptr, position, count)
end

function ParticleEmitter:destroyParticles()
  return _L._particleEmitterDestroyParticles(self._ptr)
end

function ParticleEmitter:setWorldSpace(worldSpace)
  return _L._particleEmitterSetWorldSpace(self._ptr, worldSpace)
end

function ParticleEmitter:setParticleDef(particleDef)
  return _L._particleEmitterSetParticleDef(self._ptr, particleDef)
end

function ParticleEmitter:getAliveParticleCount()
  return _L._particleEmitterGetAliveParticleCount(self._ptr)
end

function ParticleEmitter:preWarm(steps)
  _L._particleEmitterPreWarm(self._ptr, steps)
end

function ParticleEmitter:getLastDeadParticlePosition()
  local x, y = _L._particleEmitterGetLastDeadParticlePosition(self._ptr)
  return Vector(x, y)
end

return ParticleEmitter
