local _L = _L

local Component = require "lib/components/component"

-- PhysicsCollider --

local PhysicsCollider = Component()

PhysicsCollider.Types = {
  Static = 0,
  Kinematic = 1,
  Dynamic = 2
}

PhysicsCollider.Types = ReadOnlyClass(PhysicsCollider.Types, "PhysicsCollider.Types")

function PhysicsCollider:construct(object, ptr)
  self._objectId = object._objectId
  self.object = object

  self._ptr = ptr
  self._name = "PhysicsCollider"
end

function PhysicsCollider:setType(colliderType)
  _L._physicsColliderSetType(self._ptr, colliderType)
end

function PhysicsCollider:getType()
  return _L._physicsColliderGetType(self._ptr)
end

function PhysicsCollider:setCategories(categories)
  _L._physicsColliderSetCategories(self._ptr, categories)
end

function PhysicsCollider:getCategories()
  return _L._physicsColliderGetCategories(self._ptr)
end

function PhysicsCollider:setMask(mask)
  _L._physicsColliderSetMask(self._ptr, mask)
end

function PhysicsCollider:getMask()
  return _L._physicsColliderGetMask(self._ptr)
end

function PhysicsCollider:setPosition(position)
  _L._physicsColliderSetPosition(self._ptr, position)
end

function PhysicsCollider:setRotation(rotation)
  _L._physicsColliderSetRotation(self._ptr, rotation)
end

function PhysicsCollider:addCircleShape(offset, radius, info)
  info = info or {}
  info.density = info.density or 1.0
  info.friction = info.friction or 0.1
  info.restitution = info.restitution or 0.0
  info.isSensor = info.isSensor or false
  
  _L._physicsColliderAddCircleShape(self._ptr, offset, radius, info)
end

function PhysicsCollider:addRectangleShape(offset, size, info)
  info = info or {}
  info.density = info.density or 1.0
  info.friction = info.friction or 0.1
  info.restitution = info.restitution or 0.0
  info.isSensor = info.isSensor or false
  
  _L._physicsColliderAddRectangleShape(self._ptr, offset, size, info)
end

function PhysicsCollider:addPolygonShape(vertices, info)
  info = info or {}
  info.density = info.density or 1.0
  info.friction = info.friction or 0.1
  info.restitution = info.restitution or 0.0
  info.isSensor = info.isSensor or false
  
  _L._physicsColliderAddPolygonShape(self._ptr, vertices, #vertices / 2, info)
end

function PhysicsCollider:applyForce(point, force)
  _L._physicsColliderApplyForce(self._ptr, point, force)
end

function PhysicsCollider:applyForceToCenter(force)
  _L._physicsColliderApplyForceToCenter(self._ptr, force)
end

function PhysicsCollider:applyLinearImpulse(point, impulse)
  _L._physicsColliderApplyLinearImpulse(self._ptr, point, impulse)
end

function PhysicsCollider:applyAngularImpulse(impulse)
  _L._physicsColliderApplyAngularImpulse(self._ptr, impulse)
end

function PhysicsCollider:applyTorque(torque)
  _L._physicsColliderApplyTorque(self._ptr, torque)
end

function PhysicsCollider:clearForces()
  _L._physicsColliderClearForces(self._ptr)
end

function PhysicsCollider:isAwake()
  return _L._physicsColliderIsAwake(self._ptr)
end

function PhysicsCollider:setAwake(awake)
  _L._physicsColliderSetAwake(self._ptr, awake)
end

return PhysicsCollider
