local _L = _L

local Component = require "lib/components/component"

-- PhysicsJoint --

local PhysicsJoint = Component()

function PhysicsJoint:construct(object, ptr)
  self._objectId = object._objectId
  self.object = object

  self._ptr = ptr
  self._name = "PhysicsJoint"
end

function PhysicsJoint:setDistanceJoint(colliderA, colliderB, anchorA, anchorB, frequency, damping)
  frequency = frequency or 0.0
  damping = damping or 1.0

  _L._physicsJointSetDistanceJoint(self._ptr, colliderA._ptr, colliderB._ptr,
    anchorA, anchorB, frequency, damping)
end

function PhysicsJoint:setRevoluteJoint(colliderA, colliderB, anchor, jointInfo)
  jointInfo = jointInfo or {}
  local enableLimit = jointInfo.enableLimit or false
  local lowerAngle = jointInfo.lowerAngle or 0.02
  local upperAngle = jointInfo.upperAngle or 3.1415
  local enableMotor = jointInfo.enableMotor or false
  local motorSpeed = jointInfo.motorSpeed or 1.0
  local maxMotorTorque = jointInfo.maxMotorTorque or 1.0
  
  _L._physicsJointSetRevoluteJoint(self._ptr, colliderA._ptr, colliderB._ptr,
    anchor, enableLimit, lowerAngle, upperAngle, enableMotor, motorSpeed, maxMotorTorque)
end

function PhysicsJoint:setPrismaticJoint(colliderA, colliderB, anchor, jointInfo)
  jointInfo = jointInfo or {}
  local enableLimit = jointInfo.enableLimit or false
  local lowerTranslation = jointInfo.lowerTranslation or 0.0
  local upperTranslation = jointInfo.upperTranslation or 1.0
  local enableMotor = jointInfo.enableMotor or false
  local motorSpeed = jointInfo.motorSpeed or 1.0
  local maxMotorForce = jointInfo.maxMotorForce or 1.0
  
  _L._physicsJointSetPrismaticJoint(self._ptr, colliderA._ptr, colliderB._ptr,
    anchor, enableLimit, lowerTranslation, upperTranslation, enableMotor, motorSpeed, maxMotorForce)
end

function PhysicsJoint:setGearJoint(colliderA, colliderB, jointA, jointB, ratio)
  _L._physicsJointSetGearJoint(self._ptr, colliderA._ptr, colliderB._ptr,
    jointA._ptr, jointB._ptr, ratio)
end

function PhysicsJoint:setWeldJoint(colliderA, colliderB, anchor, frequency, damping)
  frequency = frequency or 0.0
  damping = damping or 1.0

  _L._physicsJointSetWeldJoint(self._ptr, colliderA._ptr, colliderB._ptr,
    anchor, frequency, damping)
end

function PhysicsJoint:getRatio()
  return _L._physicsJointGetRatio(self._ptr)
end

function PhysicsJoint:setRatio(ratio)
  _L._physicsJointSetRatio(self._ptr, ratio)
end

function PhysicsJoint:getMotorSpeed()
  return _L._physicsJointGetMotorSpeed(self._ptr)
end

function PhysicsJoint:setMotorSpeed(speed)
  _L._physicsJointSetMotorSpeed(self._ptr, speed)
end

function PhysicsJoint:setMaxMotorForce(force)
  _L._physicsJointSetMaxMotorForce(self._ptr, force)
end

function PhysicsJoint:getMaxMotorTorque()
  return _L._physicsJointGetMaxMotorTorque(self._ptr)
end

function PhysicsJoint:setMaxMotorTorque(torque)
  _L._physicsJointSetMaxMotorTorque(self._ptr, torque)
end

function PhysicsJoint:getJointAngle()
  return _L._physicsJointGetJointAngle(self._ptr)
end

function PhysicsJoint:getJointSpeed()
  return _L._physicsJointGetJointSpeed(self._ptr)
end

function PhysicsJoint:getJointTranslation()
  return _L._physicsJointGetJointTranslation(self._ptr)
end

function PhysicsJoint:getMotorTorque(invDeltaTime)
  return _L._physicsJointGetMotorTorque(self._ptr, invDeltaTime)
end

function PhysicsJoint:setLimits(lowerLimit, upperLimit)
  _L._physicsJointSetLimits(self._ptr, lowerLimit, upperLimit)
end

function PhysicsJoint:getReactionForce(invDeltaTime)
  local x, y = _L._physicsJointGetReactionForce(self._ptr, invDeltaTime)
  return Vector(x, y)
end

function PhysicsJoint:getReactionTorque(invDeltaTime)
  return _L._physicsJointGetReactionTorque(self._ptr, invDeltaTime)
end

return PhysicsJoint
