local _L = _L

local Component = require "lib/components/component"

function _skeletonRendererDispatchEvents()
  local eventQueue = {}
  _L._skeletonRendererFillAnimationEventsQueue(eventQueue)

  for i, event in ipairs(eventQueue) do
    local object = WorldObject(event.objectId)
    if object then
      object:emit(event.type, event.trackIndex, event.animationName, event.stringValue)
    end
  end
end

-- SkeletonRenderer --

local SkeletonRenderer = Component()

SkeletonRenderer.Flags = {
  AlwaysFront = 1,
  ShadowCaster = 2,
  UI = 4,
  Dissolve = 8
}

SkeletonRenderer.Flags = ReadOnlyClass(SkeletonRenderer.Flags, "SkeletonRenderer.Flags")

function SkeletonRenderer:construct(object, ptr)
  self._objectId = object._objectId
  self.object = object

  self._ptr = ptr
  self._name = "SkeletonRenderer"
end

function SkeletonRenderer:isEnabled()
  return _L._componentIsEnabled(self._ptr)
end

function SkeletonRenderer:setEnabled(enabled)
  _L._componentSetEnabled(self._ptr, enabled)
end

function SkeletonRenderer:getSkeleton()
  return _L._skeletonRendererGetSkeleton(self._ptr)
end

function SkeletonRenderer:setSkeleton(skeletonName)
  return _L._skeletonRendererSetSkeleton(self._ptr, skeletonName)
end

function SkeletonRenderer:addAnimation(trackId, animation, loop, delay)
  loop = loop or false
  delay = delay or 0.0

  _L._skeletonRendererAddAnimation(self._ptr, trackId, animation, loop, delay)
end

function SkeletonRenderer:setAnimation(trackId, animation, loop)
  loop = loop or false

  _L._skeletonRendererSetAnimation(self._ptr, trackId, animation, loop)
end

function SkeletonRenderer:getCurrentAnimation(trackId)
  local animationInfo = {}
  _L._skeletonRendererGetCurrentAnimation(self._ptr, trackId, animationInfo)
  return animationInfo
end

function SkeletonRenderer:setAttachment(slotName, attachmentName)
  _L._skeletonRendererSetAttachment(self._ptr, slotName, attachmentName)
end

function SkeletonRenderer:setSkin(skinName)
  _L._skeletonRendererSetSkin(self._ptr, skinName)
end

function SkeletonRenderer:getZOrder()
  return _L._skeletonRendererGetZOrder(self._ptr)
end

function SkeletonRenderer:setZOrder(zOrder)
  _L._skeletonRendererSetZOrder(self._ptr, zOrder)
end

function SkeletonRenderer:getTimeScale()
  return _L._skeletonRendererGetTimeScale(self._ptr)
end

function SkeletonRenderer:setTimeScale(scale)
  _L._skeletonRendererSetTimeScale(self._ptr, scale)
end

function SkeletonRenderer:enableEvents()
  _L._skeletonRendererEnableEvents(self._ptr)
end

function SkeletonRenderer:getFlag(flag)
  return _L._skeletonRendererGetFlag(self._ptr, flag)
end

function SkeletonRenderer:setFlag(flag)
  _L._skeletonRendererSetFlag(self._ptr, flag)
end

function SkeletonRenderer:unsetFlag(flag)
  _L._skeletonRendererUnsetFlag(self._ptr, flag)
end

function SkeletonRenderer:linkBoundingBoxCollider(name, object)
  _L._skeletonRendererLinkBoundingBoxCollider(self._ptr, name, object._objectId)
end

function SkeletonRenderer:getTintColor()
  local r, g, b, a = _L._skeletonRendererGetTintColor(self._ptr)
  return Color(r, g, b, a)
end

function SkeletonRenderer:setTintColor(color)
  _L._skeletonRendererSetTintColor(self._ptr, color)
end

function SkeletonRenderer:fastForward(time)
  _L._skeletonRendererUpdate(self._ptr, time)
end

return SkeletonRenderer
