local _L = _L

local Component = require "lib/components/component"

-- SoundEmitter --

local SoundEmitter = Component()

function SoundEmitter:construct(object, ptr)
  self._objectId = object._objectId
  self.object = object

  self._ptr = ptr
  self._name = "SoundEmitter"
end

function SoundEmitter:isEnabled()
  return _L._componentIsEnabled(self._ptr)
end

function SoundEmitter:setEnabled(enabled)
  _L._componentSetEnabled(self._ptr, enabled)
end

function SoundEmitter:postEvent(eventName)
  _L._soundEmitterPostEvent(self._ptr, eventName)
end

function SoundEmitter:postTrigger(triggerName)
  _L._soundEmitterPostTrigger(self._ptr, triggerName)
end

function SoundEmitter:setSwitch(switchName, value)
  _L._soundEmitterSetSwitch(self._ptr, switchName, value)
end

function SoundEmitter:setRTPC(rtpcName, value, global)
  if global then
    _L._soundEmitterSetGlobalRTPC(self._ptr, rtpcName, value)
  else
    _L._soundEmitterSetRTPC(self._ptr, rtpcName, value)
  end
end

function SoundEmitter:setOrientation(orientation)
  _L._soundEmitterSetOrientation(self._ptr, orientation)
end

function SoundEmitter:stopAllSounds()
  _L._soundEmitterStopAllSounds(self._ptr)
end

return SoundEmitter
