local _L = _L

local Component = require "lib/components/component"

-- SpriteRenderer --

local SpriteRenderer = Component()

SpriteRenderer.Flags = {
  ShadowCaster = 1,
  AlwaysBehind = 2,
  AlwaysFront = 4,
  UI = 8,
  Dissolve = 16
}

SpriteRenderer.Flags = ReadOnlyClass(SpriteRenderer.Flags, "SpriteRenderer.Flags")

SpriteRenderer.BlendMode = {
  AlphaBlend = 0,
  Additive = 1,
  Multiply = 2,
  Screen = 3
}

SpriteRenderer.BlendMode = ReadOnlyClass(SpriteRenderer.BlendMode, "SpriteRenderer.BlendMode")

function SpriteRenderer:construct(object, ptr)
  self._objectId = object._objectId
  self.object = object

  self._ptr = ptr
  self._name = "SpriteRenderer"
end

function SpriteRenderer:isEnabled()
  return _L._componentIsEnabled(self._ptr)
end

function SpriteRenderer:setEnabled(enabled)
  _L._componentSetEnabled(self._ptr, enabled)
end

function SpriteRenderer:getImage(index)
  return AssetUtil.getById(_L._spriteRendererGetImage(self._ptr, index))
end

function SpriteRenderer:addImage(imageName)
  return _L._spriteRendererAddImage(self._ptr, imageName)
end

function SpriteRenderer:getInstanceCount()
  return _L._spriteRendererGetInstanceCount(self._ptr)
end

function SpriteRenderer:addInstance(instance)
  instance = instance or {}
  instance.position = instance.position or Vector.zero()
  instance.size = instance.size or Vector.zero()
  instance.color = instance.color or Color.white
  instance.blendMode = instance.blendMode or 0
  instance.uvStart = instance.uvStart or Vector.zero()
  instance.uvEnd = instance.uvEnd or Vector(1.0, 1.0)
  instance.zOrder = instance.zOrder or 0
  instance.flags = instance.flags or 0
  instance.imageIndex = instance.imageIndex or 0

  _L._spriteRendererAddInstance(self._ptr, instance)
end

function SpriteRenderer:updateInstance(index, instance)
  instance = instance or {}
  instance.position = instance.position or Vector.zero()
  instance.size = instance.size or Vector.zero()
  instance.color = instance.color or Color.white
  instance.blendMode = instance.blendMode or 0
  instance.uvStart = instance.uvStart or Vector.zero()
  instance.uvEnd = instance.uvEnd or Vector(1.0, 1.0)
  instance.zOrder = instance.zOrder or 0
  instance.flags = instance.flags or 0
  instance.imageIndex = instance.imageIndex or 0

  _L._spriteRendererUpdateInstance(self._ptr, instance, index)
end

function SpriteRenderer:setInstancePosition(index, position)
  _L._spriteRendererUpdateInstancePosition(self._ptr, position, index)
end

function SpriteRenderer:removeInstance(index)
  return _L._spriteRendererRemoveInstance(self._ptr, index)
end

function SpriteRenderer:removeAllInstances()
  _L._spriteRendererRemoveAllInstances(self._ptr)
end

function SpriteRenderer:reserveInstances(count)
  return _L._spriteRendererReserveInstances(self._ptr, count)
end

function SpriteRenderer:isWorldSpace()
  _L._spriteRendererIsWorldSpace(self._ptr)
end

function SpriteRenderer:setWorldSpace(worldSpace)
  _L._spriteRendererSetWorldSpace(self._ptr, worldSpace)
end

function SpriteRenderer:getFadeOutSpeed()
  _L._spriteRendererGetFadeOutSpeed(self._ptr)
end

function SpriteRenderer:setFadeOutSpeed(speed)
  _L._spriteRendererSetFadeOutSpeed(self._ptr, speed)
end

return SpriteRenderer
