local _L = _L

local Component = require "lib/components/component"

-- Transform --

local Transform = Component()

function Transform:construct(object, ptr)
  self._objectId = object._objectId
  self.object = object

  self._ptr = ptr
  self._name = "Transform"
end

function Transform:getParent()
  local objectId = _L._transformGetParent(self._objectId)
  
  if objectId == 0 then
    return nil
  end
  
  return WorldObject(objectId).transform
end

function Transform:setParent(transform)
  if transform == nil then
    _L._transformSetParent(self._objectId, 0)
  else
    _L._transformSetParent(self._objectId, transform._objectId)
  end
end

function Transform:getChildren()
  local children = {}
  _L._transformGetChildren(self._objectId, children)

  local childObjects = {}
  for index, objectId in ipairs(children) do
    childObjects[index] = WorldObject(objectId)
  end
  
  return childObjects
end

function Transform:getLocalPosition()
  local x, y = _L._transformGetLocalPosition(self._ptr)
  return Vector(x, y)
end

function Transform:getWorldPosition()
  local x, y = _L._transformGetWorldPosition(self._ptr)
  return Vector(x, y)
end

function Transform:setLocalPosition(position)
  _L._transformSetLocalPosition(self._ptr, position.x, position.y)
end

function Transform:setLocalPositionAndReset(position)
  _L._transformSetLocalPositionAndReset(self._ptr, position.x, position.y)
end

function Transform:getLocalScale()
  local x, y = _L._transformGetLocalScale(self._ptr)
  return Vector(x, y)
end

function Transform:getWorldScale()
  local x, y = _L._transformGetWorldScale(self._ptr)
  return Vector(x, y)
end

function Transform:setLocalScale(scale)
  _L._transformSetLocalScale(self._ptr, scale.x, scale.y)
end

function Transform:getLocalRotation()
  return _L._transformGetLocalRotation(self._ptr)
end

function Transform:getWorldRotation()
  return _L._transformGetWorldRotation(self._ptr)
end

function Transform:setLocalRotation(rotation)
  return _L._transformSetLocalRotation(self._ptr, rotation)
end

function Transform:getWorldBounds()
  local x0, y0, x1, y1 = _L._transformGetWorldBounds(self._ptr)
  return {
    bottomLeft = Vector(x0, y0),
    topRight = Vector(x1, y1)
  }
end

function Transform:distanceTo(transform)
  return Vector.distance(self:getWorldPosition(), transform:getWorldPosition())
end

return Transform
