local editorBehaviorTypes = {}
local editorBehaviorInstances = {}

function EditorBehavior(behaviorName)
  local info = debug.getinfo(2, 'S')
  print("Registering editor behavior " .. behaviorName .. " from " .. info.source:sub(2))

  local behavior = {}
  behavior._name = behaviorName
  behavior._path = info.source:sub(2)
  editorBehaviorTypes[behaviorName] = behavior
  return behavior
end

function _instantiateEditorBehavior(behaviorName)
  if editorBehaviorTypes[behaviorName] == nil then
    print("Error! Cannot instantiate editor behavior " .. behaviorName .. " because it does not exist!")
    return nil
  end
  
  print("Instantiating editor behavior " .. behaviorName)
  
  local instance = {}
  setmetatable(instance, { __index = editorBehaviorTypes[behaviorName] } )
  
  editorBehaviorInstances[behaviorName] = instance
  
  if instance.initialize ~= nil then
    instance:initialize()
  end
  return instance
end

function _destroyEditorBehavior(behaviorName)
  editorBehaviorInstances[behaviorName] = nil
end

function _updateEditorBehaviors(deltaTime)
  for behaviorName, behavior in pairs(editorBehaviorInstances) do
    if behavior.update ~= nil then
      behavior:update(deltaTime)
    end
  end
end
