EditorUI = {}

function EditorUI.beginGroup()
  _L._editorUIBeginGroup()
end

function EditorUI.beginMenu(text)
  return _L._editorUIBeginMenu(text)
end

function EditorUI.beginMenuBar()
  return _L._editorUIBeginMenuBar()
end

function EditorUI.beginScroll(id)
  return _L._editorUIBeginChildScroll(id)
end

function EditorUI.endScroll()
  _L._editorUIEndChild()
end

function EditorUI.beginWindow(name, visible, width, height)
  if width ~= nil and height ~= nil then
    return _L._editorUIBeginWindow(name, visible, width, height)
  else
    return _L._editorUIBeginWindowAutosize(name, visible)
  end
end

function EditorUI.beginWindowMenubar(name, visible, width, height)
  return _L._editorUIBeginWindowMenubar(name, visible, width, height)
end

function EditorUI.beginWindowBorderlessMenu(name, visible, width, height)
  return _L._editorUIBeginWindowBorderlessMenu(name, visible, width, height)
end

function EditorUI.beginPopup(name)
  return _L._editorUIBeginPopup(name)
end

function EditorUI.endPopup()
  return _L._editorUIEndPopup(name)
end

function EditorUI.openPopup(name)
  _L._editorUIOpenPopup(name)
end

function EditorUI.dropdown(name, items, selectedItem)
  if EditorUI.beginPopup(name) then
    EditorUI.text(name)
    EditorUI.separator()
    for i, key in ipairs(items) do
      local selected = EditorUI.selectable(key, key == selectedItem)
    end
    
    EditorUI.endPopup()
  end
end

function EditorUI.openDropdown(name)
  EditorUI.openPopup(name)
end

function EditorUI.bullet()
  _L._editorUIBullet()
end

function EditorUI.bulletText(text)
  _L._editorUIBulletText(text)
end

function EditorUI.button(text)
  return _L._editorUIButton(text)
end

function EditorUI.checkbox(text, state)
  return _L._editorUICheckbox(text, state)
end

function EditorUI.collapsingHeader(text, defaultOpen)
  if defaultOpen == nil then
    defaultOpen = true
  end

  return _L._editorUICollapsingHeader(text, defaultOpen)
end

function EditorUI.color(text, color)
  _L._editorUIColor(text, color)
  return color
end

function EditorUI.endGroup()
  _L._editorUIEndGroup()
end

function EditorUI.endMenu()
  _L._editorUIEndMenu()
end

function EditorUI.endMenuBar()
  _L._editorUIEndMenuBar()
end

function EditorUI.endWindow()
  _L._editorUIEndWindow()
end

function EditorUI.listbox(label, currentItem, items, itemCount)
  _L._editorUIListbox(label, currentItem, items, itemCount)
end

function EditorUI.indent()
  _L._editorUIIndent()
end

function EditorUI.inputFloat(label, value, step)
  step = step or 0.25
  return _L._editorUIInputFloat(label, value, step)
end

function EditorUI.inputFloat2(label, vec)
  local x, y = _L._editorUIInputFloat2(label, vec.x, vec.y)
  return Vector(x, y)
end

function EditorUI.inputInt(label, value, step)
  step = step or 0.25
  return _L._editorUIInputInt(label, value, step)
end

function EditorUI.inputInt2(label, vec)
  local x, y = _L._editorUIInputInt2(label, vec.x, vec.y)
  return Vector(x, y)
end

function EditorUI.inputText(label, text, bufferSize, callback)
  bufferSize = bufferSize or 256
  callback = callback or function() end
  
  return _L._editorUIInputText(label, text, bufferSize, callback)
end

function EditorUI.inputTextMultiline(label, text, bufferSize)
  bufferSize = bufferSize or 256
  return _L._editorUIInputTextMultiline(label, text, bufferSize)
end

function EditorUI.isItemActive()
  return _L._editorUIIsItemActive()
end

function EditorUI.isItemHovered()
  return _L._editorUIIsItemHovered()
end

function EditorUI.menuItem(text, shortcut, selected)
  return _L._editorUIMenuItem(text, shortcut, selected)
end

function EditorUI.pushTextWrapPos(x)
  _L._editorUIPushTextWrapPos(x)
end

function EditorUI.popTextWrapPos()
  _L._editorUIPopTextWrapPos()
end

function EditorUI.radioButton(label, active)
  return _L._editorUIRadioButton(label, active)
end

function EditorUI.sameLine()
  _L._editorUISameLine()
end

function EditorUI.setScrollPosHere()
  _L._editorUISetScrollPosHere()
end

function EditorUI.setNextWindowPos(position)
  _L._editorUISetNextWindowPos(position.x, position.y)
end

function EditorUI.setNextWindowSize(size)
  _L._editorUISetNextWindowSize(size.x, size.y)
end

function EditorUI.setWindowFontScale(scale)
  _L._editorUISetWindowFontScale(scale)
end

function EditorUI.sliderFloat(text, value, valueMin, valueMax)
  return _L._editorUISliderFloat(text, value, valueMin, valueMax)
end

function EditorUI.sliderFloat2(text, value0, value1, valueMin, valueMax)
  return _L._editorUISliderFloat2(text, value0, value1, valueMin, valueMax)
end

function EditorUI.sliderInt(text, value, valueMin, valueMax)
  return _L._editorUISliderInt(text, value, valueMin, valueMax)
end

function EditorUI.separator()
  _L._editorUISeparator()
end

function EditorUI.selectable(label, selected)
  return _L._editorUISelectable(label, selected)
end

function EditorUI.spacing()
  _L._editorUISpacing()
end

function EditorUI.text(text)
  _L._editorUIText(text)
end

function EditorUI.textColored(text, color)
  _L._editorUITextColored(text, color)
end

function EditorUI.textUnformatted(text)
  _L._editorUITextUnformatted(text)
end

function EditorUI.textWrapped(text)
  _L._editorUITextWrapped(text)
end

function EditorUI.treeNode(text, id)
  id = id or text
  return _L._editorUITreeNode(text, id)
end

function EditorUI.treePop()
  _L._editorUITreePop()
end

function EditorUI.unindent()
  _L._editorUIUnindent()
end

EditorUI = ReadOnlyClass(EditorUI, "EditorUI")
