local _L = _L

Graphics = {}

local defaultFontPath = "default/default.otf"
local defaultFont = nil

function Graphics.drawImage(image, info)
  info = info or {}
  info.position = info.position or Vector.zero()
  info.size = info.size or image:getSize()
  info.tint = info.tint or Color.white
  info.uvStart = info.uvStart or Vector.zero()
  info.uvEnd = info.uvEnd or Vector(1.0, 1.0)
  info.zOrder = info.zOrder or 0
  info.isUI = info.isUI or false
  info.outline = info.outline or false

  _L._graphicsDrawImage(image._ptr, info)
end

function Graphics.drawMesh(image, info)
  info = info or {}
  info.zOrder = info.zOrder or 0
  info.isUI = info.isUI or false
  info.outline = info.outline or false
  info.position = info.position or Vector.zero()

  if not info.vertexCount or info.vertexCount == 0 then
    return
  end

  _L._graphicsDrawMesh(image._ptr, info)
end

function Graphics.measureText(text, font, scale)
  scale = scale or 1.0

  if not defaultFont then
    defaultFont = AssetUtil.find(defaultFontPath)
  end

  font = font or defaultFont
  local x, y = _L._graphicsMeasureText(text, font._ptr, scale)
  return Vector(x, y)
end

function Graphics.drawText(text, info)
  if not defaultFont then
    defaultFont = AssetUtil.find(defaultFontPath)
  end

  info = info or {}
  info.position = info.position or Vector.zero()
  info.color = info.color or Color(1.0, 1.0, 1.0, 1.0)
  info.font = info.font or defaultFont
  info.zOrder = info.zOrder or 0
  info.isUI = info.isUI or false
  info.scale = info.scale or 1.0
  
  _L._graphicsDrawText(text, info.position, info.color, info.font._ptr, info.scale, info.zOrder, info.isUI)
end

function Graphics.setColorLUT(image, leftOrRight)
  _L._graphicsSetColorLUT(image._ptr, leftOrRight)
end

function Graphics.setColorLUTAlpha(alpha)
  _L._graphicsSetColorLUTAlpha(alpha)
end

function Graphics.reloadShaders()
  _L._graphicsReloadShaders()
end

function Graphics.setFogOfWarImage(image)
  _L._graphicsSetFogOfWarImage(image._ptr)
end

function Graphics.useFogOfWar(state)
  _L._graphicsUseFogOfWar(state)
end

Graphics = ReadOnlyClass(Graphics, "Graphics")
