local InputEvents = EventEmitter()

local SourceEnum = {
  [0] = "Keyboard",
  [1] = "Controller"
}

local EventTypeEnum = {
  [0] = "ButtonPressed",
  [1] = "ButtonReleased",
  [2] = "AnalogValueChanged",
  [3] = "ControllerConnected",
  [4] = "ControllerDisconnected"
}

local X360AxisEnum = {
  [0] = "LS",
  [1] = "RS",
  [2] = "LT",
  [3] = "RT"
}

local X360ButtonsEnum = {
  [0] = "DUp",
  [1] = "DDown",
  [2] = "DLeft",
  [3] = "DRight",
  [4] = "Start",
  [5] = "Back",
  [6] = "LSB",
  [7] = "RSB",
  [8] = "LB",
  [9] = "RB",
  [12] = "A",
  [13] = "B",
  [14] = "X",
  [15] = "Y"
}

function _inputDrainMessageQueue()
  local events = {}
  _L._inputDrainMessageQueue(events)

  for i, event in ipairs(events) do
    local source = SourceEnum[event.source]
    local type = EventTypeEnum[event.type]

    local info = {
      type = type,
      source = source
    }

    if source == "Keyboard" then
      info.button = event.controlId
    else
      info.controllerIndex = event.deviceId

      if type == "AnalogValueChanged" then
        info.axis = X360AxisEnum[event.controlId]
        info.value = Vector(event.x, event.y)
      else
        info.button = X360ButtonsEnum[event.controlId]
      end
    end

    InputEvents:emit("event", info)
  end
end

return ReadOnlyClass(InputEvents, "InputEvents")
