inspect = require "lib/inspect"

function ReadOnlyClass(class, className)
  return setmetatable({}, {
     __index = class,
     __newindex = function(table, key, value)
                    error("Attempt to modify read-only class " .. className)
                  end,
     __metatable = false
   })
end

Bitwise = require "bit"

JSON = require "lib/json"
i18n = require "lib/i18n"

Co = require "lib/co"

require "lib/class"
require "lib/eventemitter"

require "lib/config"
require "lib/util"
require "lib/stringutil"
require "lib/vector"
require "lib/color"
require "lib/math"
require "lib/timer"

require "lib/editorbehavior"
require "lib/editorui"

require "lib/object"
require "lib/behavior"
require "lib/behaviorutil"
require "lib/input"
require "lib/debug"
require "lib/camera"
require "lib/assetutil"
require "lib/graphics"
require "lib/physics"
require "lib/pathfinding"
require "lib/worldutil"
require "lib/sound"
require "lib/screen"
require "lib/time"
require "lib/random"
require "lib/ui"
require "lib/pathutil"

require "lib/asset/_all"
