function math.epsCompare(a, b, eps)
  return math.abs(a - b) < eps
end

function math.clamp(a, x, y)
  if a < x then
    a = x
  elseif a > y then
    a = y
  end

  return a
end

function math.lerp(a, b, t)
  return a * (1.0 - t) + b * t
end

function math.sign(a)
  if a < 0.0 then
    return -1.0
  elseif a > 0.0 then
    return 1.0
  else
    return 0.0
  end
end
