local _L = _L

local Transform = require "lib/components/transform"
local WorldObjectBase = require "lib/worldobjectbase"

local worldObjectCache = {}

function _notifyObjectDestroyed(objectId)
  _destroyBehaviorsForObject(objectId)
  worldObjectCache[objectId] = nil
end

local createWorldObject = function (objectId)
  local worldObject = {}
  
  setmetatable(worldObject, { 
    __index = WorldObjectBase
  })
  
  worldObject:construct(objectId)

  if objectId == 0 then
    return worldObject
  end

  if not _L._objectExists(objectId) then
    return nil
  end
  
  worldObject.transform = Transform(worldObject, _L._getTransformPtr(worldObject._objectId))

  setmetatable(worldObject, { 
    __index = WorldObjectBase,
    __newindex = function(t, k, v)
      print("ERROR! WorldObject cannot assign to field \"" .. k 
        .. "\" as object is read-only (stacktrace follows)")
        
      print(debug.traceback())
      return
    end,
    __eq = function (lhs, rhs)
      return lhs._objectId == rhs._objectId
    end
  })

  return worldObject
end

WorldObject = {}
setmetatable(WorldObject, {
  __call = function(_, objectId)
    if objectId ~= 0 and not _L._objectExists(objectId) then
      worldObjectCache[objectId] = nil
      return nil
    end

    if not worldObjectCache[objectId] then
      worldObjectCache[objectId] = createWorldObject(objectId)
    end
    
    return worldObjectCache[objectId]
  end
})

function CreateObject(objectName, position, parentObject)
  position = position or Vector.zero()
  local parentObjectId = 0
  
  if parentObject then
    parentObjectId = parentObject._objectId
  end

  return WorldObject(_L._createObject(parentObjectId, objectName, position.x, position.y))
end
