local AI = require "util/aicommon"

local PathBase = {}

function PathBase:drawDebug()
  for i, node in pairs(self.nodes) do
    Debug.drawCircle(node, 6.0, 0x00FF00FF)
  end
  
  for i = 1, self.nodeCount - 1 do
    Debug.drawLine(self.nodes[i], self.nodes[i+1], 0xFF00FFFF)
  end
end

local requestQueue = {}
local nextPathId = 0

function _pathfindingHandleIncomingRequests()
  local requests = {}
  _L._pathfinderFillCompletedRequestsBuffer(requests)

  local halfTile = Vector(9.0, 9.0)

  for index, pathData in ipairs(requests) do
    local callback = requestQueue[pathData.pathId]
    if callback ~= nil then
      local path = {
        nodeCount = pathData.nodeCount,
        nodes = {},
        found = pathData.found
      }

      setmetatable(path, { __index = PathBase })
      
      if path.found then
        for index, node in ipairs(pathData.nodes) do
          path.nodes[index] = Vector(node) - halfTile
        end
        
        callback(path)
      else
        callback(nil)
      end
    end
    
    requestQueue[pathData.pathId] = nil
  end
end

Pathfinding = {}

function Pathfinding.sampleCollisionAvoidance(position)
  local x, y = _L._collisionAvoidanceSample(position.x, position.y)
  return Vector(x, y)
end

function Pathfinding.sampleCollisionAvoidanceBilinear(position)
  local x, y = _L._collisionAvoidanceSampleBilinear(position.x, position.y)
  return Vector(x, y)
end

function Pathfinding.findPath(from, to, callback)
  local pathId = nextPathId + 1
  nextPathId = nextPathId + 1
  _L._pathfinderFindPath(pathId, from.x, from.y, to.x, to.y)
  requestQueue[pathId] = callback
end

-- Pulls the current node away from any walls by agentRadius
function Pathfinding.pullNodeAwayFromWalls(node, agentRadius)
  local sample = Pathfinding.sampleCollisionAvoidanceBilinear(node)
  node = node + sample * agentRadius * 4.0
  return node
end

Pathfinding = ReadOnlyClass(Pathfinding, "Pathfinding")
