local _L = _L

Physics = {}

function Physics.pauseSim(paused)
  _L._physicsPauseSim(paused)
end

function Physics.isSimPaused()
  return _L._physicsIsSimPaused()
end

function Physics.setGravity(gravity)
  return _L._physicsSetGravity(gravity)
end

function Physics.lineOfSight(v0, v1, layerMask)
  local los = true
  layerMask = layerMask or World.layer("World")

  Physics.raycast(v0, v1, function (hitInfo)
    los = false
  end, layerMask)

  return los
end

function Physics.raycast(v0, v1, callback, mask)
  if not mask then
    mask = 255
  end
  
  _L._physicsRaycast(v0.x, v0.y, v1.x, v1.y, mask, function(objectId, pointX, pointY, normalX, normalY, fraction)
    return callback({
      object = WorldObject(objectId),
      point = Vector(pointX, pointY),
      normal = Vector(normalX, normalY),
      fraction = fraction
    })
  end)
end

function Physics.aabbQuery(bottomLeft, topRight, callback, mask)
  if not mask then
    mask = 255
  end
  
  _L._physicsAABBQuery(bottomLeft.x, bottomLeft.y, topRight.x, topRight.y, mask, function(objectId)
    return callback(WorldObject(objectId))
  end)
end

function Physics.doSingleStep(timeStep)
  _L._physicsDoSingleStep(timeStep)
end

function _physicsDispatchCollisionInfo()
  local contacts = {}
  _L._physicsFillContactsBuffer(contacts)
  
  for index, contactInfo in ipairs(contacts) do
    local event = "collisionStart"
    if contactInfo.endContact then
      event = "collisionEnd"
    end

    local objectA = WorldObject(contactInfo.objectIdA)
    local objectB = WorldObject(contactInfo.objectIdB)
    
    if objectA and objectB then
      local pointA = Vector(contactInfo.pointA)
      local pointB = Vector(contactInfo.pointB)

      local normal = Vector(contactInfo.normal)

      if objectA:hasAnyListeners(event) then
        objectA:emit(event, {
          self = objectA,
          object = objectB,
          pointSelf = pointA,
          pointOther = pointB,
          normal = normal,
          separationSelf = contactInfo.separationB,
          separationOther = contactInfo.separationA
        })
      end

      if objectB:hasAnyListeners(event) then
        objectB:emit(event, {
          self = objectB,
          object = objectA,
          pointSelf = pointB,
          pointOther = pointA,
          normal = normal,
          separationSelf = contactInfo.separationB,
          separationOther = contactInfo.separationA
        })
      end
    end
  end
end

Physics = ReadOnlyClass(Physics, "Physics")
